/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Context {
    COST_AND_USAGE("COST_AND_USAGE"),
    RESERVATIONS("RESERVATIONS"),
    SAVINGS_PLANS("SAVINGS_PLANS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Context> VALUE_MAP;
    private final String value;

    private Context(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Context fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Context> knownValues() {
        EnumSet<Context> knownValues = EnumSet.allOf(Context.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Context.class, Context::toString);
    }
}

