/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartSavingsPlansPurchaseRecommendationGenerationResponse
extends CostExplorerResponse
implements ToCopyableBuilder<Builder, StartSavingsPlansPurchaseRecommendationGenerationResponse> {
    private static final SdkField<String> RECOMMENDATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecommendationId").getter(StartSavingsPlansPurchaseRecommendationGenerationResponse.getter(StartSavingsPlansPurchaseRecommendationGenerationResponse::recommendationId)).setter(StartSavingsPlansPurchaseRecommendationGenerationResponse.setter(Builder::recommendationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationId").build()}).build();
    private static final SdkField<String> GENERATION_STARTED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GenerationStartedTime").getter(StartSavingsPlansPurchaseRecommendationGenerationResponse.getter(StartSavingsPlansPurchaseRecommendationGenerationResponse::generationStartedTime)).setter(StartSavingsPlansPurchaseRecommendationGenerationResponse.setter(Builder::generationStartedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenerationStartedTime").build()}).build();
    private static final SdkField<String> ESTIMATED_COMPLETION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EstimatedCompletionTime").getter(StartSavingsPlansPurchaseRecommendationGenerationResponse.getter(StartSavingsPlansPurchaseRecommendationGenerationResponse::estimatedCompletionTime)).setter(StartSavingsPlansPurchaseRecommendationGenerationResponse.setter(Builder::estimatedCompletionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedCompletionTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDATION_ID_FIELD, GENERATION_STARTED_TIME_FIELD, ESTIMATED_COMPLETION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartSavingsPlansPurchaseRecommendationGenerationResponse.memberNameToFieldInitializer();
    private final String recommendationId;
    private final String generationStartedTime;
    private final String estimatedCompletionTime;

    private StartSavingsPlansPurchaseRecommendationGenerationResponse(BuilderImpl builder) {
        super(builder);
        this.recommendationId = builder.recommendationId;
        this.generationStartedTime = builder.generationStartedTime;
        this.estimatedCompletionTime = builder.estimatedCompletionTime;
    }

    public final String recommendationId() {
        return this.recommendationId;
    }

    public final String generationStartedTime() {
        return this.generationStartedTime;
    }

    public final String estimatedCompletionTime() {
        return this.estimatedCompletionTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.generationStartedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedCompletionTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSavingsPlansPurchaseRecommendationGenerationResponse)) {
            return false;
        }
        StartSavingsPlansPurchaseRecommendationGenerationResponse other = (StartSavingsPlansPurchaseRecommendationGenerationResponse)((Object)obj);
        return Objects.equals(this.recommendationId(), other.recommendationId()) && Objects.equals(this.generationStartedTime(), other.generationStartedTime()) && Objects.equals(this.estimatedCompletionTime(), other.estimatedCompletionTime());
    }

    public final String toString() {
        return ToString.builder((String)"StartSavingsPlansPurchaseRecommendationGenerationResponse").add("RecommendationId", (Object)this.recommendationId()).add("GenerationStartedTime", (Object)this.generationStartedTime()).add("EstimatedCompletionTime", (Object)this.estimatedCompletionTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecommendationId": {
                return Optional.ofNullable(clazz.cast(this.recommendationId()));
            }
            case "GenerationStartedTime": {
                return Optional.ofNullable(clazz.cast(this.generationStartedTime()));
            }
            case "EstimatedCompletionTime": {
                return Optional.ofNullable(clazz.cast(this.estimatedCompletionTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("RecommendationId", RECOMMENDATION_ID_FIELD);
        map.put("GenerationStartedTime", GENERATION_STARTED_TIME_FIELD);
        map.put("EstimatedCompletionTime", ESTIMATED_COMPLETION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartSavingsPlansPurchaseRecommendationGenerationResponse, T> g) {
        return obj -> g.apply((StartSavingsPlansPurchaseRecommendationGenerationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostExplorerResponse.BuilderImpl
    implements Builder {
        private String recommendationId;
        private String generationStartedTime;
        private String estimatedCompletionTime;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSavingsPlansPurchaseRecommendationGenerationResponse model) {
            super(model);
            this.recommendationId(model.recommendationId);
            this.generationStartedTime(model.generationStartedTime);
            this.estimatedCompletionTime(model.estimatedCompletionTime);
        }

        public final String getRecommendationId() {
            return this.recommendationId;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        @Override
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public final String getGenerationStartedTime() {
            return this.generationStartedTime;
        }

        public final void setGenerationStartedTime(String generationStartedTime) {
            this.generationStartedTime = generationStartedTime;
        }

        @Override
        public final Builder generationStartedTime(String generationStartedTime) {
            this.generationStartedTime = generationStartedTime;
            return this;
        }

        public final String getEstimatedCompletionTime() {
            return this.estimatedCompletionTime;
        }

        public final void setEstimatedCompletionTime(String estimatedCompletionTime) {
            this.estimatedCompletionTime = estimatedCompletionTime;
        }

        @Override
        public final Builder estimatedCompletionTime(String estimatedCompletionTime) {
            this.estimatedCompletionTime = estimatedCompletionTime;
            return this;
        }

        @Override
        public StartSavingsPlansPurchaseRecommendationGenerationResponse build() {
            return new StartSavingsPlansPurchaseRecommendationGenerationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CostExplorerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartSavingsPlansPurchaseRecommendationGenerationResponse> {
        public Builder recommendationId(String var1);

        public Builder generationStartedTime(String var1);

        public Builder estimatedCompletionTime(String var1);
    }
}

