/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.CostCategoryProcessingStatus;
import software.amazon.awssdk.services.costexplorer.model.CostCategoryProcessingStatusListCopier;
import software.amazon.awssdk.services.costexplorer.model.CostCategoryRule;
import software.amazon.awssdk.services.costexplorer.model.CostCategoryRuleVersion;
import software.amazon.awssdk.services.costexplorer.model.CostCategoryRulesListCopier;
import software.amazon.awssdk.services.costexplorer.model.CostCategorySplitChargeRule;
import software.amazon.awssdk.services.costexplorer.model.CostCategorySplitChargeRulesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CostCategory
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CostCategory> {
    private static final SdkField<String> COST_CATEGORY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CostCategoryArn").getter(CostCategory.getter(CostCategory::costCategoryArn)).setter(CostCategory.setter(Builder::costCategoryArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CostCategoryArn").build()}).build();
    private static final SdkField<String> EFFECTIVE_START_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EffectiveStart").getter(CostCategory.getter(CostCategory::effectiveStart)).setter(CostCategory.setter(Builder::effectiveStart)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EffectiveStart").build()}).build();
    private static final SdkField<String> EFFECTIVE_END_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EffectiveEnd").getter(CostCategory.getter(CostCategory::effectiveEnd)).setter(CostCategory.setter(Builder::effectiveEnd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EffectiveEnd").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CostCategory.getter(CostCategory::name)).setter(CostCategory.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> RULE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleVersion").getter(CostCategory.getter(CostCategory::ruleVersionAsString)).setter(CostCategory.setter(Builder::ruleVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleVersion").build()}).build();
    private static final SdkField<List<CostCategoryRule>> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Rules").getter(CostCategory.getter(CostCategory::rules)).setter(CostCategory.setter(Builder::rules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CostCategoryRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CostCategorySplitChargeRule>> SPLIT_CHARGE_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SplitChargeRules").getter(CostCategory.getter(CostCategory::splitChargeRules)).setter(CostCategory.setter(Builder::splitChargeRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SplitChargeRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CostCategorySplitChargeRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CostCategoryProcessingStatus>> PROCESSING_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProcessingStatus").getter(CostCategory.getter(CostCategory::processingStatus)).setter(CostCategory.setter(Builder::processingStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingStatus").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CostCategoryProcessingStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultValue").getter(CostCategory.getter(CostCategory::defaultValue)).setter(CostCategory.setter(Builder::defaultValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COST_CATEGORY_ARN_FIELD, EFFECTIVE_START_FIELD, EFFECTIVE_END_FIELD, NAME_FIELD, RULE_VERSION_FIELD, RULES_FIELD, SPLIT_CHARGE_RULES_FIELD, PROCESSING_STATUS_FIELD, DEFAULT_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CostCategoryArn", COST_CATEGORY_ARN_FIELD);
            this.put("EffectiveStart", EFFECTIVE_START_FIELD);
            this.put("EffectiveEnd", EFFECTIVE_END_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("RuleVersion", RULE_VERSION_FIELD);
            this.put("Rules", RULES_FIELD);
            this.put("SplitChargeRules", SPLIT_CHARGE_RULES_FIELD);
            this.put("ProcessingStatus", PROCESSING_STATUS_FIELD);
            this.put("DefaultValue", DEFAULT_VALUE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String costCategoryArn;
    private final String effectiveStart;
    private final String effectiveEnd;
    private final String name;
    private final String ruleVersion;
    private final List<CostCategoryRule> rules;
    private final List<CostCategorySplitChargeRule> splitChargeRules;
    private final List<CostCategoryProcessingStatus> processingStatus;
    private final String defaultValue;

    private CostCategory(BuilderImpl builder) {
        this.costCategoryArn = builder.costCategoryArn;
        this.effectiveStart = builder.effectiveStart;
        this.effectiveEnd = builder.effectiveEnd;
        this.name = builder.name;
        this.ruleVersion = builder.ruleVersion;
        this.rules = builder.rules;
        this.splitChargeRules = builder.splitChargeRules;
        this.processingStatus = builder.processingStatus;
        this.defaultValue = builder.defaultValue;
    }

    public final String costCategoryArn() {
        return this.costCategoryArn;
    }

    public final String effectiveStart() {
        return this.effectiveStart;
    }

    public final String effectiveEnd() {
        return this.effectiveEnd;
    }

    public final String name() {
        return this.name;
    }

    public final CostCategoryRuleVersion ruleVersion() {
        return CostCategoryRuleVersion.fromValue(this.ruleVersion);
    }

    public final String ruleVersionAsString() {
        return this.ruleVersion;
    }

    public final boolean hasRules() {
        return this.rules != null && !(this.rules instanceof SdkAutoConstructList);
    }

    public final List<CostCategoryRule> rules() {
        return this.rules;
    }

    public final boolean hasSplitChargeRules() {
        return this.splitChargeRules != null && !(this.splitChargeRules instanceof SdkAutoConstructList);
    }

    public final List<CostCategorySplitChargeRule> splitChargeRules() {
        return this.splitChargeRules;
    }

    public final boolean hasProcessingStatus() {
        return this.processingStatus != null && !(this.processingStatus instanceof SdkAutoConstructList);
    }

    public final List<CostCategoryProcessingStatus> processingStatus() {
        return this.processingStatus;
    }

    public final String defaultValue() {
        return this.defaultValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.costCategoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.effectiveStart());
        hashCode = 31 * hashCode + Objects.hashCode(this.effectiveEnd());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRules() ? this.rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSplitChargeRules() ? this.splitChargeRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProcessingStatus() ? this.processingStatus() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CostCategory)) {
            return false;
        }
        CostCategory other = (CostCategory)obj;
        return Objects.equals(this.costCategoryArn(), other.costCategoryArn()) && Objects.equals(this.effectiveStart(), other.effectiveStart()) && Objects.equals(this.effectiveEnd(), other.effectiveEnd()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.ruleVersionAsString(), other.ruleVersionAsString()) && this.hasRules() == other.hasRules() && Objects.equals(this.rules(), other.rules()) && this.hasSplitChargeRules() == other.hasSplitChargeRules() && Objects.equals(this.splitChargeRules(), other.splitChargeRules()) && this.hasProcessingStatus() == other.hasProcessingStatus() && Objects.equals(this.processingStatus(), other.processingStatus()) && Objects.equals(this.defaultValue(), other.defaultValue());
    }

    public final String toString() {
        return ToString.builder((String)"CostCategory").add("CostCategoryArn", (Object)this.costCategoryArn()).add("EffectiveStart", (Object)this.effectiveStart()).add("EffectiveEnd", (Object)this.effectiveEnd()).add("Name", (Object)this.name()).add("RuleVersion", (Object)this.ruleVersionAsString()).add("Rules", this.hasRules() ? this.rules() : null).add("SplitChargeRules", this.hasSplitChargeRules() ? this.splitChargeRules() : null).add("ProcessingStatus", this.hasProcessingStatus() ? this.processingStatus() : null).add("DefaultValue", (Object)this.defaultValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CostCategoryArn": {
                return Optional.ofNullable(clazz.cast(this.costCategoryArn()));
            }
            case "EffectiveStart": {
                return Optional.ofNullable(clazz.cast(this.effectiveStart()));
            }
            case "EffectiveEnd": {
                return Optional.ofNullable(clazz.cast(this.effectiveEnd()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RuleVersion": {
                return Optional.ofNullable(clazz.cast(this.ruleVersionAsString()));
            }
            case "Rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
            case "SplitChargeRules": {
                return Optional.ofNullable(clazz.cast(this.splitChargeRules()));
            }
            case "ProcessingStatus": {
                return Optional.ofNullable(clazz.cast(this.processingStatus()));
            }
            case "DefaultValue": {
                return Optional.ofNullable(clazz.cast(this.defaultValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CostCategory, T> g) {
        return obj -> g.apply((CostCategory)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String costCategoryArn;
        private String effectiveStart;
        private String effectiveEnd;
        private String name;
        private String ruleVersion;
        private List<CostCategoryRule> rules = DefaultSdkAutoConstructList.getInstance();
        private List<CostCategorySplitChargeRule> splitChargeRules = DefaultSdkAutoConstructList.getInstance();
        private List<CostCategoryProcessingStatus> processingStatus = DefaultSdkAutoConstructList.getInstance();
        private String defaultValue;

        private BuilderImpl() {
        }

        private BuilderImpl(CostCategory model) {
            this.costCategoryArn(model.costCategoryArn);
            this.effectiveStart(model.effectiveStart);
            this.effectiveEnd(model.effectiveEnd);
            this.name(model.name);
            this.ruleVersion(model.ruleVersion);
            this.rules(model.rules);
            this.splitChargeRules(model.splitChargeRules);
            this.processingStatus(model.processingStatus);
            this.defaultValue(model.defaultValue);
        }

        public final String getCostCategoryArn() {
            return this.costCategoryArn;
        }

        public final void setCostCategoryArn(String costCategoryArn) {
            this.costCategoryArn = costCategoryArn;
        }

        @Override
        public final Builder costCategoryArn(String costCategoryArn) {
            this.costCategoryArn = costCategoryArn;
            return this;
        }

        public final String getEffectiveStart() {
            return this.effectiveStart;
        }

        public final void setEffectiveStart(String effectiveStart) {
            this.effectiveStart = effectiveStart;
        }

        @Override
        public final Builder effectiveStart(String effectiveStart) {
            this.effectiveStart = effectiveStart;
            return this;
        }

        public final String getEffectiveEnd() {
            return this.effectiveEnd;
        }

        public final void setEffectiveEnd(String effectiveEnd) {
            this.effectiveEnd = effectiveEnd;
        }

        @Override
        public final Builder effectiveEnd(String effectiveEnd) {
            this.effectiveEnd = effectiveEnd;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRuleVersion() {
            return this.ruleVersion;
        }

        public final void setRuleVersion(String ruleVersion) {
            this.ruleVersion = ruleVersion;
        }

        @Override
        public final Builder ruleVersion(String ruleVersion) {
            this.ruleVersion = ruleVersion;
            return this;
        }

        @Override
        public final Builder ruleVersion(CostCategoryRuleVersion ruleVersion) {
            this.ruleVersion(ruleVersion == null ? null : ruleVersion.toString());
            return this;
        }

        public final List<CostCategoryRule.Builder> getRules() {
            List<CostCategoryRule.Builder> result = CostCategoryRulesListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<CostCategoryRule.BuilderImpl> rules) {
            this.rules = CostCategoryRulesListCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<CostCategoryRule> rules) {
            this.rules = CostCategoryRulesListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(CostCategoryRule ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<CostCategoryRule.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (CostCategoryRule)((CostCategoryRule.Builder)CostCategoryRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CostCategorySplitChargeRule.Builder> getSplitChargeRules() {
            List<CostCategorySplitChargeRule.Builder> result = CostCategorySplitChargeRulesListCopier.copyToBuilder(this.splitChargeRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSplitChargeRules(Collection<CostCategorySplitChargeRule.BuilderImpl> splitChargeRules) {
            this.splitChargeRules = CostCategorySplitChargeRulesListCopier.copyFromBuilder(splitChargeRules);
        }

        @Override
        public final Builder splitChargeRules(Collection<CostCategorySplitChargeRule> splitChargeRules) {
            this.splitChargeRules = CostCategorySplitChargeRulesListCopier.copy(splitChargeRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder splitChargeRules(CostCategorySplitChargeRule ... splitChargeRules) {
            this.splitChargeRules(Arrays.asList(splitChargeRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder splitChargeRules(Consumer<CostCategorySplitChargeRule.Builder> ... splitChargeRules) {
            this.splitChargeRules(Stream.of(splitChargeRules).map(c -> (CostCategorySplitChargeRule)((CostCategorySplitChargeRule.Builder)CostCategorySplitChargeRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CostCategoryProcessingStatus.Builder> getProcessingStatus() {
            List<CostCategoryProcessingStatus.Builder> result = CostCategoryProcessingStatusListCopier.copyToBuilder(this.processingStatus);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProcessingStatus(Collection<CostCategoryProcessingStatus.BuilderImpl> processingStatus) {
            this.processingStatus = CostCategoryProcessingStatusListCopier.copyFromBuilder(processingStatus);
        }

        @Override
        public final Builder processingStatus(Collection<CostCategoryProcessingStatus> processingStatus) {
            this.processingStatus = CostCategoryProcessingStatusListCopier.copy(processingStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processingStatus(CostCategoryProcessingStatus ... processingStatus) {
            this.processingStatus(Arrays.asList(processingStatus));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processingStatus(Consumer<CostCategoryProcessingStatus.Builder> ... processingStatus) {
            this.processingStatus(Stream.of(processingStatus).map(c -> (CostCategoryProcessingStatus)((CostCategoryProcessingStatus.Builder)CostCategoryProcessingStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDefaultValue() {
            return this.defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public CostCategory build() {
            return new CostCategory(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CostCategory> {
        public Builder costCategoryArn(String var1);

        public Builder effectiveStart(String var1);

        public Builder effectiveEnd(String var1);

        public Builder name(String var1);

        public Builder ruleVersion(String var1);

        public Builder ruleVersion(CostCategoryRuleVersion var1);

        public Builder rules(Collection<CostCategoryRule> var1);

        public Builder rules(CostCategoryRule ... var1);

        public Builder rules(Consumer<CostCategoryRule.Builder> ... var1);

        public Builder splitChargeRules(Collection<CostCategorySplitChargeRule> var1);

        public Builder splitChargeRules(CostCategorySplitChargeRule ... var1);

        public Builder splitChargeRules(Consumer<CostCategorySplitChargeRule.Builder> ... var1);

        public Builder processingStatus(Collection<CostCategoryProcessingStatus> var1);

        public Builder processingStatus(CostCategoryProcessingStatus ... var1);

        public Builder processingStatus(Consumer<CostCategoryProcessingStatus.Builder> ... var1);

        public Builder defaultValue(String var1);
    }
}

