/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.costexplorer.model.SubscriberStatus;
import software.amazon.awssdk.services.costexplorer.model.SubscriberType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Subscriber
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Subscriber> {
    private static final SdkField<String> ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Address").getter(Subscriber.getter(Subscriber::address)).setter(Subscriber.setter(Builder::address)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(Subscriber.getter(Subscriber::typeAsString)).setter(Subscriber.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Subscriber.getter(Subscriber::statusAsString)).setter(Subscriber.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_FIELD, TYPE_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String address;
    private final String type;
    private final String status;

    private Subscriber(BuilderImpl builder) {
        this.address = builder.address;
        this.type = builder.type;
        this.status = builder.status;
    }

    public final String address() {
        return this.address;
    }

    public final SubscriberType type() {
        return SubscriberType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final SubscriberStatus status() {
        return SubscriberStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.address());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Subscriber)) {
            return false;
        }
        Subscriber other = (Subscriber)obj;
        return Objects.equals(this.address(), other.address()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Subscriber").add("Address", (Object)this.address()).add("Type", (Object)this.typeAsString()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Address": {
                return Optional.ofNullable(clazz.cast(this.address()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Subscriber, T> g) {
        return obj -> g.apply((Subscriber)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String address;
        private String type;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(Subscriber model) {
            this.address(model.address);
            this.type(model.type);
            this.status(model.status);
        }

        public final String getAddress() {
            return this.address;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SubscriberType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SubscriberStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public Subscriber build() {
            return new Subscriber(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Subscriber> {
        public Builder address(String var1);

        public Builder type(String var1);

        public Builder type(SubscriberType var1);

        public Builder status(String var1);

        public Builder status(SubscriberStatus var1);
    }
}

