/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CostCategoryRuleType {
    REGULAR("REGULAR"),
    INHERITED_VALUE("INHERITED_VALUE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CostCategoryRuleType> VALUE_MAP;
    private final String value;

    private CostCategoryRuleType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CostCategoryRuleType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CostCategoryRuleType> knownValues() {
        EnumSet<CostCategoryRuleType> knownValues = EnumSet.allOf(CostCategoryRuleType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CostCategoryRuleType.class, CostCategoryRuleType::toString);
    }
}

