/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerResponse;
import software.amazon.awssdk.services.costexplorer.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTagsResponse
extends CostExplorerResponse
implements ToCopyableBuilder<Builder, GetTagsResponse> {
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextPageToken").getter(GetTagsResponse.getter(GetTagsResponse::nextPageToken)).setter(GetTagsResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()}).build();
    private static final SdkField<List<String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(GetTagsResponse.getter(GetTagsResponse::tags)).setter(GetTagsResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> RETURN_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ReturnSize").getter(GetTagsResponse.getter(GetTagsResponse::returnSize)).setter(GetTagsResponse.setter(Builder::returnSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnSize").build()}).build();
    private static final SdkField<Integer> TOTAL_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalSize").getter(GetTagsResponse.getter(GetTagsResponse::totalSize)).setter(GetTagsResponse.setter(Builder::totalSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalSize").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_PAGE_TOKEN_FIELD, TAGS_FIELD, RETURN_SIZE_FIELD, TOTAL_SIZE_FIELD));
    private final String nextPageToken;
    private final List<String> tags;
    private final Integer returnSize;
    private final Integer totalSize;

    private GetTagsResponse(BuilderImpl builder) {
        super(builder);
        this.nextPageToken = builder.nextPageToken;
        this.tags = builder.tags;
        this.returnSize = builder.returnSize;
        this.totalSize = builder.totalSize;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<String> tags() {
        return this.tags;
    }

    public final Integer returnSize() {
        return this.returnSize;
    }

    public final Integer totalSize() {
        return this.totalSize;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.returnSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalSize());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTagsResponse)) {
            return false;
        }
        GetTagsResponse other = (GetTagsResponse)((Object)obj);
        return Objects.equals(this.nextPageToken(), other.nextPageToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.returnSize(), other.returnSize()) && Objects.equals(this.totalSize(), other.totalSize());
    }

    public final String toString() {
        return ToString.builder((String)"GetTagsResponse").add("NextPageToken", (Object)this.nextPageToken()).add("Tags", this.hasTags() ? this.tags() : null).add("ReturnSize", (Object)this.returnSize()).add("TotalSize", (Object)this.totalSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ReturnSize": {
                return Optional.ofNullable(clazz.cast(this.returnSize()));
            }
            case "TotalSize": {
                return Optional.ofNullable(clazz.cast(this.totalSize()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTagsResponse, T> g) {
        return obj -> g.apply((GetTagsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostExplorerResponse.BuilderImpl
    implements Builder {
        private String nextPageToken;
        private List<String> tags = DefaultSdkAutoConstructList.getInstance();
        private Integer returnSize;
        private Integer totalSize;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTagsResponse model) {
            super(model);
            this.nextPageToken(model.nextPageToken);
            this.tags(model.tags);
            this.returnSize(model.returnSize);
            this.totalSize(model.totalSize);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final Collection<String> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Collection<String> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @Override
        public final Builder tags(Collection<String> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(String ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final Integer getReturnSize() {
            return this.returnSize;
        }

        public final void setReturnSize(Integer returnSize) {
            this.returnSize = returnSize;
        }

        @Override
        public final Builder returnSize(Integer returnSize) {
            this.returnSize = returnSize;
            return this;
        }

        public final Integer getTotalSize() {
            return this.totalSize;
        }

        public final void setTotalSize(Integer totalSize) {
            this.totalSize = totalSize;
        }

        @Override
        public final Builder totalSize(Integer totalSize) {
            this.totalSize = totalSize;
            return this;
        }

        @Override
        public GetTagsResponse build() {
            return new GetTagsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CostExplorerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTagsResponse> {
        public Builder nextPageToken(String var1);

        public Builder tags(Collection<String> var1);

        public Builder tags(String ... var1);

        public Builder returnSize(Integer var1);

        public Builder totalSize(Integer var1);
    }
}

