/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.DateInterval;
import software.amazon.awssdk.services.costexplorer.model.ReservationAggregates;
import software.amazon.awssdk.services.costexplorer.model.ReservationUtilizationGroup;
import software.amazon.awssdk.services.costexplorer.model.ReservationUtilizationGroupsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UtilizationByTime
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UtilizationByTime> {
    private static final SdkField<DateInterval> TIME_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimePeriod").getter(UtilizationByTime.getter(UtilizationByTime::timePeriod)).setter(UtilizationByTime.setter(Builder::timePeriod)).constructor(DateInterval::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimePeriod").build()}).build();
    private static final SdkField<List<ReservationUtilizationGroup>> GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Groups").getter(UtilizationByTime.getter(UtilizationByTime::groups)).setter(UtilizationByTime.setter(Builder::groups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Groups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReservationUtilizationGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ReservationAggregates> TOTAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Total").getter(UtilizationByTime.getter(UtilizationByTime::total)).setter(UtilizationByTime.setter(Builder::total)).constructor(ReservationAggregates::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Total").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_PERIOD_FIELD, GROUPS_FIELD, TOTAL_FIELD));
    private static final long serialVersionUID = 1L;
    private final DateInterval timePeriod;
    private final List<ReservationUtilizationGroup> groups;
    private final ReservationAggregates total;

    private UtilizationByTime(BuilderImpl builder) {
        this.timePeriod = builder.timePeriod;
        this.groups = builder.groups;
        this.total = builder.total;
    }

    public final DateInterval timePeriod() {
        return this.timePeriod;
    }

    public final boolean hasGroups() {
        return this.groups != null && !(this.groups instanceof SdkAutoConstructList);
    }

    public final List<ReservationUtilizationGroup> groups() {
        return this.groups;
    }

    public final ReservationAggregates total() {
        return this.total;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroups() ? this.groups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.total());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UtilizationByTime)) {
            return false;
        }
        UtilizationByTime other = (UtilizationByTime)obj;
        return Objects.equals(this.timePeriod(), other.timePeriod()) && this.hasGroups() == other.hasGroups() && Objects.equals(this.groups(), other.groups()) && Objects.equals(this.total(), other.total());
    }

    public final String toString() {
        return ToString.builder((String)"UtilizationByTime").add("TimePeriod", (Object)this.timePeriod()).add("Groups", this.hasGroups() ? this.groups() : null).add("Total", (Object)this.total()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TimePeriod": {
                return Optional.ofNullable(clazz.cast(this.timePeriod()));
            }
            case "Groups": {
                return Optional.ofNullable(clazz.cast(this.groups()));
            }
            case "Total": {
                return Optional.ofNullable(clazz.cast(this.total()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UtilizationByTime, T> g) {
        return obj -> g.apply((UtilizationByTime)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DateInterval timePeriod;
        private List<ReservationUtilizationGroup> groups = DefaultSdkAutoConstructList.getInstance();
        private ReservationAggregates total;

        private BuilderImpl() {
        }

        private BuilderImpl(UtilizationByTime model) {
            this.timePeriod(model.timePeriod);
            this.groups(model.groups);
            this.total(model.total);
        }

        public final DateInterval.Builder getTimePeriod() {
            return this.timePeriod != null ? this.timePeriod.toBuilder() : null;
        }

        public final void setTimePeriod(DateInterval.BuilderImpl timePeriod) {
            this.timePeriod = timePeriod != null ? timePeriod.build() : null;
        }

        @Override
        public final Builder timePeriod(DateInterval timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        public final List<ReservationUtilizationGroup.Builder> getGroups() {
            List<ReservationUtilizationGroup.Builder> result = ReservationUtilizationGroupsCopier.copyToBuilder(this.groups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroups(Collection<ReservationUtilizationGroup.BuilderImpl> groups) {
            this.groups = ReservationUtilizationGroupsCopier.copyFromBuilder(groups);
        }

        @Override
        public final Builder groups(Collection<ReservationUtilizationGroup> groups) {
            this.groups = ReservationUtilizationGroupsCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(ReservationUtilizationGroup ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Consumer<ReservationUtilizationGroup.Builder> ... groups) {
            this.groups(Stream.of(groups).map(c -> (ReservationUtilizationGroup)((ReservationUtilizationGroup.Builder)ReservationUtilizationGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ReservationAggregates.Builder getTotal() {
            return this.total != null ? this.total.toBuilder() : null;
        }

        public final void setTotal(ReservationAggregates.BuilderImpl total) {
            this.total = total != null ? total.build() : null;
        }

        @Override
        public final Builder total(ReservationAggregates total) {
            this.total = total;
            return this;
        }

        public UtilizationByTime build() {
            return new UtilizationByTime(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UtilizationByTime> {
        public Builder timePeriod(DateInterval var1);

        default public Builder timePeriod(Consumer<DateInterval.Builder> timePeriod) {
            return this.timePeriod((DateInterval)((DateInterval.Builder)DateInterval.builder().applyMutation(timePeriod)).build());
        }

        public Builder groups(Collection<ReservationUtilizationGroup> var1);

        public Builder groups(ReservationUtilizationGroup ... var1);

        public Builder groups(Consumer<ReservationUtilizationGroup.Builder> ... var1);

        public Builder total(ReservationAggregates var1);

        default public Builder total(Consumer<ReservationAggregates.Builder> total) {
            return this.total((ReservationAggregates)((ReservationAggregates.Builder)ReservationAggregates.builder().applyMutation(total)).build());
        }
    }
}

