/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.AnomaliesCopier;
import software.amazon.awssdk.services.costexplorer.model.Anomaly;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAnomaliesResponse
extends CostExplorerResponse
implements ToCopyableBuilder<Builder, GetAnomaliesResponse> {
    private static final SdkField<List<Anomaly>> ANOMALIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Anomalies").getter(GetAnomaliesResponse.getter(GetAnomaliesResponse::anomalies)).setter(GetAnomaliesResponse.setter(Builder::anomalies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Anomalies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Anomaly::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextPageToken").getter(GetAnomaliesResponse.getter(GetAnomaliesResponse::nextPageToken)).setter(GetAnomaliesResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALIES_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private final List<Anomaly> anomalies;
    private final String nextPageToken;

    private GetAnomaliesResponse(BuilderImpl builder) {
        super(builder);
        this.anomalies = builder.anomalies;
        this.nextPageToken = builder.nextPageToken;
    }

    public final boolean hasAnomalies() {
        return this.anomalies != null && !(this.anomalies instanceof SdkAutoConstructList);
    }

    public final List<Anomaly> anomalies() {
        return this.anomalies;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnomalies() ? this.anomalies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAnomaliesResponse)) {
            return false;
        }
        GetAnomaliesResponse other = (GetAnomaliesResponse)((Object)obj);
        return this.hasAnomalies() == other.hasAnomalies() && Objects.equals(this.anomalies(), other.anomalies()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetAnomaliesResponse").add("Anomalies", this.hasAnomalies() ? this.anomalies() : null).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Anomalies": {
                return Optional.ofNullable(clazz.cast(this.anomalies()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAnomaliesResponse, T> g) {
        return obj -> g.apply((GetAnomaliesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostExplorerResponse.BuilderImpl
    implements Builder {
        private List<Anomaly> anomalies = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAnomaliesResponse model) {
            super(model);
            this.anomalies(model.anomalies);
            this.nextPageToken(model.nextPageToken);
        }

        public final List<Anomaly.Builder> getAnomalies() {
            List<Anomaly.Builder> result = AnomaliesCopier.copyToBuilder(this.anomalies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnomalies(Collection<Anomaly.BuilderImpl> anomalies) {
            this.anomalies = AnomaliesCopier.copyFromBuilder(anomalies);
        }

        @Override
        @Transient
        public final Builder anomalies(Collection<Anomaly> anomalies) {
            this.anomalies = AnomaliesCopier.copy(anomalies);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder anomalies(Anomaly ... anomalies) {
            this.anomalies(Arrays.asList(anomalies));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder anomalies(Consumer<Anomaly.Builder> ... anomalies) {
            this.anomalies(Stream.of(anomalies).map(c -> (Anomaly)((Anomaly.Builder)Anomaly.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        @Transient
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public GetAnomaliesResponse build() {
            return new GetAnomaliesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CostExplorerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAnomaliesResponse> {
        public Builder anomalies(Collection<Anomaly> var1);

        public Builder anomalies(Anomaly ... var1);

        public Builder anomalies(Consumer<Anomaly.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

