/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerRequest;
import software.amazon.awssdk.services.costexplorer.model.ValuesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAnomalySubscriptionsRequest
extends CostExplorerRequest
implements ToCopyableBuilder<Builder, GetAnomalySubscriptionsRequest> {
    private static final SdkField<List<String>> SUBSCRIPTION_ARN_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubscriptionArnList").getter(GetAnomalySubscriptionsRequest.getter(GetAnomalySubscriptionsRequest::subscriptionArnList)).setter(GetAnomalySubscriptionsRequest.setter(Builder::subscriptionArnList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionArnList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MONITOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonitorArn").getter(GetAnomalySubscriptionsRequest.getter(GetAnomalySubscriptionsRequest::monitorArn)).setter(GetAnomalySubscriptionsRequest.setter(Builder::monitorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitorArn").build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextPageToken").getter(GetAnomalySubscriptionsRequest.getter(GetAnomalySubscriptionsRequest::nextPageToken)).setter(GetAnomalySubscriptionsRequest.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetAnomalySubscriptionsRequest.getter(GetAnomalySubscriptionsRequest::maxResults)).setter(GetAnomalySubscriptionsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBSCRIPTION_ARN_LIST_FIELD, MONITOR_ARN_FIELD, NEXT_PAGE_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final List<String> subscriptionArnList;
    private final String monitorArn;
    private final String nextPageToken;
    private final Integer maxResults;

    private GetAnomalySubscriptionsRequest(BuilderImpl builder) {
        super(builder);
        this.subscriptionArnList = builder.subscriptionArnList;
        this.monitorArn = builder.monitorArn;
        this.nextPageToken = builder.nextPageToken;
        this.maxResults = builder.maxResults;
    }

    public final boolean hasSubscriptionArnList() {
        return this.subscriptionArnList != null && !(this.subscriptionArnList instanceof SdkAutoConstructList);
    }

    public final List<String> subscriptionArnList() {
        return this.subscriptionArnList;
    }

    public final String monitorArn() {
        return this.monitorArn;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubscriptionArnList() ? this.subscriptionArnList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.monitorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAnomalySubscriptionsRequest)) {
            return false;
        }
        GetAnomalySubscriptionsRequest other = (GetAnomalySubscriptionsRequest)((Object)obj);
        return this.hasSubscriptionArnList() == other.hasSubscriptionArnList() && Objects.equals(this.subscriptionArnList(), other.subscriptionArnList()) && Objects.equals(this.monitorArn(), other.monitorArn()) && Objects.equals(this.nextPageToken(), other.nextPageToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"GetAnomalySubscriptionsRequest").add("SubscriptionArnList", this.hasSubscriptionArnList() ? this.subscriptionArnList() : null).add("MonitorArn", (Object)this.monitorArn()).add("NextPageToken", (Object)this.nextPageToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubscriptionArnList": {
                return Optional.ofNullable(clazz.cast(this.subscriptionArnList()));
            }
            case "MonitorArn": {
                return Optional.ofNullable(clazz.cast(this.monitorArn()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAnomalySubscriptionsRequest, T> g) {
        return obj -> g.apply((GetAnomalySubscriptionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostExplorerRequest.BuilderImpl
    implements Builder {
        private List<String> subscriptionArnList = DefaultSdkAutoConstructList.getInstance();
        private String monitorArn;
        private String nextPageToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAnomalySubscriptionsRequest model) {
            super(model);
            this.subscriptionArnList(model.subscriptionArnList);
            this.monitorArn(model.monitorArn);
            this.nextPageToken(model.nextPageToken);
            this.maxResults(model.maxResults);
        }

        public final Collection<String> getSubscriptionArnList() {
            if (this.subscriptionArnList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subscriptionArnList;
        }

        public final void setSubscriptionArnList(Collection<String> subscriptionArnList) {
            this.subscriptionArnList = ValuesCopier.copy(subscriptionArnList);
        }

        @Override
        @Transient
        public final Builder subscriptionArnList(Collection<String> subscriptionArnList) {
            this.subscriptionArnList = ValuesCopier.copy(subscriptionArnList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder subscriptionArnList(String ... subscriptionArnList) {
            this.subscriptionArnList(Arrays.asList(subscriptionArnList));
            return this;
        }

        public final String getMonitorArn() {
            return this.monitorArn;
        }

        public final void setMonitorArn(String monitorArn) {
            this.monitorArn = monitorArn;
        }

        @Override
        @Transient
        public final Builder monitorArn(String monitorArn) {
            this.monitorArn = monitorArn;
            return this;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        @Transient
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAnomalySubscriptionsRequest build() {
            return new GetAnomalySubscriptionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CostExplorerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAnomalySubscriptionsRequest> {
        public Builder subscriptionArnList(Collection<String> var1);

        public Builder subscriptionArnList(String ... var1);

        public Builder monitorArn(String var1);

        public Builder nextPageToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

