/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.Context;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerRequest;
import software.amazon.awssdk.services.costexplorer.model.DateInterval;
import software.amazon.awssdk.services.costexplorer.model.Dimension;
import software.amazon.awssdk.services.costexplorer.model.Expression;
import software.amazon.awssdk.services.costexplorer.model.SortDefinition;
import software.amazon.awssdk.services.costexplorer.model.SortDefinitionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDimensionValuesRequest
extends CostExplorerRequest
implements ToCopyableBuilder<Builder, GetDimensionValuesRequest> {
    private static final SdkField<String> SEARCH_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SearchString").getter(GetDimensionValuesRequest.getter(GetDimensionValuesRequest::searchString)).setter(GetDimensionValuesRequest.setter(Builder::searchString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchString").build()}).build();
    private static final SdkField<DateInterval> TIME_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimePeriod").getter(GetDimensionValuesRequest.getter(GetDimensionValuesRequest::timePeriod)).setter(GetDimensionValuesRequest.setter(Builder::timePeriod)).constructor(DateInterval::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimePeriod").build()}).build();
    private static final SdkField<String> DIMENSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Dimension").getter(GetDimensionValuesRequest.getter(GetDimensionValuesRequest::dimensionAsString)).setter(GetDimensionValuesRequest.setter(Builder::dimension)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimension").build()}).build();
    private static final SdkField<String> CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Context").getter(GetDimensionValuesRequest.getter(GetDimensionValuesRequest::contextAsString)).setter(GetDimensionValuesRequest.setter(Builder::context)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Context").build()}).build();
    private static final SdkField<Expression> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Filter").getter(GetDimensionValuesRequest.getter(GetDimensionValuesRequest::filter)).setter(GetDimensionValuesRequest.setter(Builder::filter)).constructor(Expression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()}).build();
    private static final SdkField<List<SortDefinition>> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SortBy").getter(GetDimensionValuesRequest.getter(GetDimensionValuesRequest::sortBy)).setter(GetDimensionValuesRequest.setter(Builder::sortBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SortDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetDimensionValuesRequest.getter(GetDimensionValuesRequest::maxResults)).setter(GetDimensionValuesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextPageToken").getter(GetDimensionValuesRequest.getter(GetDimensionValuesRequest::nextPageToken)).setter(GetDimensionValuesRequest.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEARCH_STRING_FIELD, TIME_PERIOD_FIELD, DIMENSION_FIELD, CONTEXT_FIELD, FILTER_FIELD, SORT_BY_FIELD, MAX_RESULTS_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private final String searchString;
    private final DateInterval timePeriod;
    private final String dimension;
    private final String context;
    private final Expression filter;
    private final List<SortDefinition> sortBy;
    private final Integer maxResults;
    private final String nextPageToken;

    private GetDimensionValuesRequest(BuilderImpl builder) {
        super(builder);
        this.searchString = builder.searchString;
        this.timePeriod = builder.timePeriod;
        this.dimension = builder.dimension;
        this.context = builder.context;
        this.filter = builder.filter;
        this.sortBy = builder.sortBy;
        this.maxResults = builder.maxResults;
        this.nextPageToken = builder.nextPageToken;
    }

    public final String searchString() {
        return this.searchString;
    }

    public final DateInterval timePeriod() {
        return this.timePeriod;
    }

    public final Dimension dimension() {
        return Dimension.fromValue(this.dimension);
    }

    public final String dimensionAsString() {
        return this.dimension;
    }

    public final Context context() {
        return Context.fromValue(this.context);
    }

    public final String contextAsString() {
        return this.context;
    }

    public final Expression filter() {
        return this.filter;
    }

    public final boolean hasSortBy() {
        return this.sortBy != null && !(this.sortBy instanceof SdkAutoConstructList);
    }

    public final List<SortDefinition> sortBy() {
        return this.sortBy;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.searchString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.dimensionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.contextAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSortBy() ? this.sortBy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDimensionValuesRequest)) {
            return false;
        }
        GetDimensionValuesRequest other = (GetDimensionValuesRequest)((Object)obj);
        return Objects.equals(this.searchString(), other.searchString()) && Objects.equals(this.timePeriod(), other.timePeriod()) && Objects.equals(this.dimensionAsString(), other.dimensionAsString()) && Objects.equals(this.contextAsString(), other.contextAsString()) && Objects.equals(this.filter(), other.filter()) && this.hasSortBy() == other.hasSortBy() && Objects.equals(this.sortBy(), other.sortBy()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetDimensionValuesRequest").add("SearchString", (Object)this.searchString()).add("TimePeriod", (Object)this.timePeriod()).add("Dimension", (Object)this.dimensionAsString()).add("Context", (Object)this.contextAsString()).add("Filter", (Object)this.filter()).add("SortBy", this.hasSortBy() ? this.sortBy() : null).add("MaxResults", (Object)this.maxResults()).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SearchString": {
                return Optional.ofNullable(clazz.cast(this.searchString()));
            }
            case "TimePeriod": {
                return Optional.ofNullable(clazz.cast(this.timePeriod()));
            }
            case "Dimension": {
                return Optional.ofNullable(clazz.cast(this.dimensionAsString()));
            }
            case "Context": {
                return Optional.ofNullable(clazz.cast(this.contextAsString()));
            }
            case "Filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
            case "SortBy": {
                return Optional.ofNullable(clazz.cast(this.sortBy()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDimensionValuesRequest, T> g) {
        return obj -> g.apply((GetDimensionValuesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostExplorerRequest.BuilderImpl
    implements Builder {
        private String searchString;
        private DateInterval timePeriod;
        private String dimension;
        private String context;
        private Expression filter;
        private List<SortDefinition> sortBy = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDimensionValuesRequest model) {
            super(model);
            this.searchString(model.searchString);
            this.timePeriod(model.timePeriod);
            this.dimension(model.dimension);
            this.context(model.context);
            this.filter(model.filter);
            this.sortBy(model.sortBy);
            this.maxResults(model.maxResults);
            this.nextPageToken(model.nextPageToken);
        }

        public final String getSearchString() {
            return this.searchString;
        }

        @Override
        public final Builder searchString(String searchString) {
            this.searchString = searchString;
            return this;
        }

        public final void setSearchString(String searchString) {
            this.searchString = searchString;
        }

        public final DateInterval.Builder getTimePeriod() {
            return this.timePeriod != null ? this.timePeriod.toBuilder() : null;
        }

        @Override
        public final Builder timePeriod(DateInterval timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        public final void setTimePeriod(DateInterval.BuilderImpl timePeriod) {
            this.timePeriod = timePeriod != null ? timePeriod.build() : null;
        }

        public final String getDimension() {
            return this.dimension;
        }

        @Override
        public final Builder dimension(String dimension) {
            this.dimension = dimension;
            return this;
        }

        @Override
        public final Builder dimension(Dimension dimension) {
            this.dimension(dimension == null ? null : dimension.toString());
            return this;
        }

        public final void setDimension(String dimension) {
            this.dimension = dimension;
        }

        public final String getContext() {
            return this.context;
        }

        @Override
        public final Builder context(String context) {
            this.context = context;
            return this;
        }

        @Override
        public final Builder context(Context context) {
            this.context(context == null ? null : context.toString());
            return this;
        }

        public final void setContext(String context) {
            this.context = context;
        }

        public final Expression.Builder getFilter() {
            return this.filter != null ? this.filter.toBuilder() : null;
        }

        @Override
        public final Builder filter(Expression filter) {
            this.filter = filter;
            return this;
        }

        public final void setFilter(Expression.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        public final List<SortDefinition.Builder> getSortBy() {
            List<SortDefinition.Builder> result = SortDefinitionsCopier.copyToBuilder(this.sortBy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder sortBy(Collection<SortDefinition> sortBy) {
            this.sortBy = SortDefinitionsCopier.copy(sortBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortBy(SortDefinition ... sortBy) {
            this.sortBy(Arrays.asList(sortBy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortBy(Consumer<SortDefinition.Builder> ... sortBy) {
            this.sortBy(Stream.of(sortBy).map(c -> (SortDefinition)((SortDefinition.Builder)SortDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSortBy(Collection<SortDefinition.BuilderImpl> sortBy) {
            this.sortBy = SortDefinitionsCopier.copyFromBuilder(sortBy);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDimensionValuesRequest build() {
            return new GetDimensionValuesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CostExplorerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDimensionValuesRequest> {
        public Builder searchString(String var1);

        public Builder timePeriod(DateInterval var1);

        default public Builder timePeriod(Consumer<DateInterval.Builder> timePeriod) {
            return this.timePeriod((DateInterval)((DateInterval.Builder)DateInterval.builder().applyMutation(timePeriod)).build());
        }

        public Builder dimension(String var1);

        public Builder dimension(Dimension var1);

        public Builder context(String var1);

        public Builder context(Context var1);

        public Builder filter(Expression var1);

        default public Builder filter(Consumer<Expression.Builder> filter) {
            return this.filter((Expression)((Expression.Builder)Expression.builder().applyMutation(filter)).build());
        }

        public Builder sortBy(Collection<SortDefinition> var1);

        public Builder sortBy(SortDefinition ... var1);

        public Builder sortBy(Consumer<SortDefinition.Builder> ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextPageToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

