/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum MonitorType {
    DIMENSIONAL("DIMENSIONAL"),
    CUSTOM("CUSTOM"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private MonitorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MonitorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(MonitorType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MonitorType> knownValues() {
        return Stream.of(MonitorType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

