/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCostCategoryDefinitionsResponse extends CostExplorerResponse implements
        ToCopyableBuilder<ListCostCategoryDefinitionsResponse.Builder, ListCostCategoryDefinitionsResponse> {
    private static final SdkField<List<CostCategoryReference>> COST_CATEGORY_REFERENCES_FIELD = SdkField
            .<List<CostCategoryReference>> builder(MarshallingType.LIST)
            .memberName("CostCategoryReferences")
            .getter(getter(ListCostCategoryDefinitionsResponse::costCategoryReferences))
            .setter(setter(Builder::costCategoryReferences))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CostCategoryReferences").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CostCategoryReference> builder(MarshallingType.SDK_POJO)
                                            .constructor(CostCategoryReference::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListCostCategoryDefinitionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            COST_CATEGORY_REFERENCES_FIELD, NEXT_TOKEN_FIELD));

    private final List<CostCategoryReference> costCategoryReferences;

    private final String nextToken;

    private ListCostCategoryDefinitionsResponse(BuilderImpl builder) {
        super(builder);
        this.costCategoryReferences = builder.costCategoryReferences;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the CostCategoryReferences property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasCostCategoryReferences() {
        return costCategoryReferences != null && !(costCategoryReferences instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A reference to a Cost Category containing enough information to identify the Cost Category.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCostCategoryReferences()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A reference to a Cost Category containing enough information to identify the Cost Category.
     */
    public final List<CostCategoryReference> costCategoryReferences() {
        return costCategoryReferences;
    }

    /**
     * <p>
     * The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a
     * previous call has more results than the maximum page size.
     * </p>
     * 
     * @return The token to retrieve the next set of results. Amazon Web Services provides the token when the response
     *         from a previous call has more results than the maximum page size.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCostCategoryReferences() ? costCategoryReferences() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCostCategoryDefinitionsResponse)) {
            return false;
        }
        ListCostCategoryDefinitionsResponse other = (ListCostCategoryDefinitionsResponse) obj;
        return hasCostCategoryReferences() == other.hasCostCategoryReferences()
                && Objects.equals(costCategoryReferences(), other.costCategoryReferences())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCostCategoryDefinitionsResponse")
                .add("CostCategoryReferences", hasCostCategoryReferences() ? costCategoryReferences() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CostCategoryReferences":
            return Optional.ofNullable(clazz.cast(costCategoryReferences()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCostCategoryDefinitionsResponse, T> g) {
        return obj -> g.apply((ListCostCategoryDefinitionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCostCategoryDefinitionsResponse> {
        /**
         * <p>
         * A reference to a Cost Category containing enough information to identify the Cost Category.
         * </p>
         * 
         * @param costCategoryReferences
         *        A reference to a Cost Category containing enough information to identify the Cost Category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costCategoryReferences(Collection<CostCategoryReference> costCategoryReferences);

        /**
         * <p>
         * A reference to a Cost Category containing enough information to identify the Cost Category.
         * </p>
         * 
         * @param costCategoryReferences
         *        A reference to a Cost Category containing enough information to identify the Cost Category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costCategoryReferences(CostCategoryReference... costCategoryReferences);

        /**
         * <p>
         * A reference to a Cost Category containing enough information to identify the Cost Category.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CostCategoryReference>.Builder} avoiding
         * the need to create one manually via {@link List<CostCategoryReference>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CostCategoryReference>.Builder#build()} is called
         * immediately and its result is passed to {@link #costCategoryReferences(List<CostCategoryReference>)}.
         * 
         * @param costCategoryReferences
         *        a consumer that will call methods on {@link List<CostCategoryReference>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #costCategoryReferences(List<CostCategoryReference>)
         */
        Builder costCategoryReferences(Consumer<CostCategoryReference.Builder>... costCategoryReferences);

        /**
         * <p>
         * The token to retrieve the next set of results. Amazon Web Services provides the token when the response from
         * a previous call has more results than the maximum page size.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next set of results. Amazon Web Services provides the token when the
         *        response from a previous call has more results than the maximum page size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CostExplorerResponse.BuilderImpl implements Builder {
        private List<CostCategoryReference> costCategoryReferences = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCostCategoryDefinitionsResponse model) {
            super(model);
            costCategoryReferences(model.costCategoryReferences);
            nextToken(model.nextToken);
        }

        public final Collection<CostCategoryReference.Builder> getCostCategoryReferences() {
            if (costCategoryReferences instanceof SdkAutoConstructList) {
                return null;
            }
            return costCategoryReferences != null ? costCategoryReferences.stream().map(CostCategoryReference::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder costCategoryReferences(Collection<CostCategoryReference> costCategoryReferences) {
            this.costCategoryReferences = CostCategoryReferencesListCopier.copy(costCategoryReferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder costCategoryReferences(CostCategoryReference... costCategoryReferences) {
            costCategoryReferences(Arrays.asList(costCategoryReferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder costCategoryReferences(Consumer<CostCategoryReference.Builder>... costCategoryReferences) {
            costCategoryReferences(Stream.of(costCategoryReferences)
                    .map(c -> CostCategoryReference.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCostCategoryReferences(Collection<CostCategoryReference.BuilderImpl> costCategoryReferences) {
            this.costCategoryReferences = CostCategoryReferencesListCopier.copyFromBuilder(costCategoryReferences);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListCostCategoryDefinitionsResponse build() {
            return new ListCostCategoryDefinitionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
