/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCostAndUsageWithResourcesResponse extends CostExplorerResponse implements
        ToCopyableBuilder<GetCostAndUsageWithResourcesResponse.Builder, GetCostAndUsageWithResourcesResponse> {
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextPageToken").getter(getter(GetCostAndUsageWithResourcesResponse::nextPageToken))
            .setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final SdkField<List<GroupDefinition>> GROUP_DEFINITIONS_FIELD = SdkField
            .<List<GroupDefinition>> builder(MarshallingType.LIST)
            .memberName("GroupDefinitions")
            .getter(getter(GetCostAndUsageWithResourcesResponse::groupDefinitions))
            .setter(setter(Builder::groupDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GroupDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(GroupDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ResultByTime>> RESULTS_BY_TIME_FIELD = SdkField
            .<List<ResultByTime>> builder(MarshallingType.LIST)
            .memberName("ResultsByTime")
            .getter(getter(GetCostAndUsageWithResourcesResponse::resultsByTime))
            .setter(setter(Builder::resultsByTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultsByTime").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResultByTime> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResultByTime::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DimensionValuesWithAttributes>> DIMENSION_VALUE_ATTRIBUTES_FIELD = SdkField
            .<List<DimensionValuesWithAttributes>> builder(MarshallingType.LIST)
            .memberName("DimensionValueAttributes")
            .getter(getter(GetCostAndUsageWithResourcesResponse::dimensionValueAttributes))
            .setter(setter(Builder::dimensionValueAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionValueAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DimensionValuesWithAttributes> builder(MarshallingType.SDK_POJO)
                                            .constructor(DimensionValuesWithAttributes::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_PAGE_TOKEN_FIELD,
            GROUP_DEFINITIONS_FIELD, RESULTS_BY_TIME_FIELD, DIMENSION_VALUE_ATTRIBUTES_FIELD));

    private final String nextPageToken;

    private final List<GroupDefinition> groupDefinitions;

    private final List<ResultByTime> resultsByTime;

    private final List<DimensionValuesWithAttributes> dimensionValueAttributes;

    private GetCostAndUsageWithResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.nextPageToken = builder.nextPageToken;
        this.groupDefinitions = builder.groupDefinitions;
        this.resultsByTime = builder.resultsByTime;
        this.dimensionValueAttributes = builder.dimensionValueAttributes;
    }

    /**
     * <p>
     * The token for the next set of retrievable results. AWS provides the token when the response from a previous call
     * has more results than the maximum page size.
     * </p>
     * 
     * @return The token for the next set of retrievable results. AWS provides the token when the response from a
     *         previous call has more results than the maximum page size.
     */
    public final String nextPageToken() {
        return nextPageToken;
    }

    /**
     * Returns true if the GroupDefinitions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasGroupDefinitions() {
        return groupDefinitions != null && !(groupDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The groups that are specified by the <code>Filter</code> or <code>GroupBy</code> parameters in the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGroupDefinitions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The groups that are specified by the <code>Filter</code> or <code>GroupBy</code> parameters in the
     *         request.
     */
    public final List<GroupDefinition> groupDefinitions() {
        return groupDefinitions;
    }

    /**
     * Returns true if the ResultsByTime property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasResultsByTime() {
        return resultsByTime != null && !(resultsByTime instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The time period that is covered by the results in the response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResultsByTime()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The time period that is covered by the results in the response.
     */
    public final List<ResultByTime> resultsByTime() {
        return resultsByTime;
    }

    /**
     * Returns true if the DimensionValueAttributes property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasDimensionValueAttributes() {
        return dimensionValueAttributes != null && !(dimensionValueAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The attributes that apply to a specific dimension value. For example, if the value is a linked account, the
     * attribute is that account name.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDimensionValueAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The attributes that apply to a specific dimension value. For example, if the value is a linked account,
     *         the attribute is that account name.
     */
    public final List<DimensionValuesWithAttributes> dimensionValueAttributes() {
        return dimensionValueAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupDefinitions() ? groupDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResultsByTime() ? resultsByTime() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDimensionValueAttributes() ? dimensionValueAttributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCostAndUsageWithResourcesResponse)) {
            return false;
        }
        GetCostAndUsageWithResourcesResponse other = (GetCostAndUsageWithResourcesResponse) obj;
        return Objects.equals(nextPageToken(), other.nextPageToken()) && hasGroupDefinitions() == other.hasGroupDefinitions()
                && Objects.equals(groupDefinitions(), other.groupDefinitions()) && hasResultsByTime() == other.hasResultsByTime()
                && Objects.equals(resultsByTime(), other.resultsByTime())
                && hasDimensionValueAttributes() == other.hasDimensionValueAttributes()
                && Objects.equals(dimensionValueAttributes(), other.dimensionValueAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCostAndUsageWithResourcesResponse").add("NextPageToken", nextPageToken())
                .add("GroupDefinitions", hasGroupDefinitions() ? groupDefinitions() : null)
                .add("ResultsByTime", hasResultsByTime() ? resultsByTime() : null)
                .add("DimensionValueAttributes", hasDimensionValueAttributes() ? dimensionValueAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        case "GroupDefinitions":
            return Optional.ofNullable(clazz.cast(groupDefinitions()));
        case "ResultsByTime":
            return Optional.ofNullable(clazz.cast(resultsByTime()));
        case "DimensionValueAttributes":
            return Optional.ofNullable(clazz.cast(dimensionValueAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCostAndUsageWithResourcesResponse, T> g) {
        return obj -> g.apply((GetCostAndUsageWithResourcesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetCostAndUsageWithResourcesResponse> {
        /**
         * <p>
         * The token for the next set of retrievable results. AWS provides the token when the response from a previous
         * call has more results than the maximum page size.
         * </p>
         * 
         * @param nextPageToken
         *        The token for the next set of retrievable results. AWS provides the token when the response from a
         *        previous call has more results than the maximum page size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);

        /**
         * <p>
         * The groups that are specified by the <code>Filter</code> or <code>GroupBy</code> parameters in the request.
         * </p>
         * 
         * @param groupDefinitions
         *        The groups that are specified by the <code>Filter</code> or <code>GroupBy</code> parameters in the
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupDefinitions(Collection<GroupDefinition> groupDefinitions);

        /**
         * <p>
         * The groups that are specified by the <code>Filter</code> or <code>GroupBy</code> parameters in the request.
         * </p>
         * 
         * @param groupDefinitions
         *        The groups that are specified by the <code>Filter</code> or <code>GroupBy</code> parameters in the
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupDefinitions(GroupDefinition... groupDefinitions);

        /**
         * <p>
         * The groups that are specified by the <code>Filter</code> or <code>GroupBy</code> parameters in the request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<GroupDefinition>.Builder} avoiding the need
         * to create one manually via {@link List<GroupDefinition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GroupDefinition>.Builder#build()} is called immediately and
         * its result is passed to {@link #groupDefinitions(List<GroupDefinition>)}.
         * 
         * @param groupDefinitions
         *        a consumer that will call methods on {@link List<GroupDefinition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupDefinitions(List<GroupDefinition>)
         */
        Builder groupDefinitions(Consumer<GroupDefinition.Builder>... groupDefinitions);

        /**
         * <p>
         * The time period that is covered by the results in the response.
         * </p>
         * 
         * @param resultsByTime
         *        The time period that is covered by the results in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultsByTime(Collection<ResultByTime> resultsByTime);

        /**
         * <p>
         * The time period that is covered by the results in the response.
         * </p>
         * 
         * @param resultsByTime
         *        The time period that is covered by the results in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultsByTime(ResultByTime... resultsByTime);

        /**
         * <p>
         * The time period that is covered by the results in the response.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResultByTime>.Builder} avoiding the need to
         * create one manually via {@link List<ResultByTime>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResultByTime>.Builder#build()} is called immediately and its
         * result is passed to {@link #resultsByTime(List<ResultByTime>)}.
         * 
         * @param resultsByTime
         *        a consumer that will call methods on {@link List<ResultByTime>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resultsByTime(List<ResultByTime>)
         */
        Builder resultsByTime(Consumer<ResultByTime.Builder>... resultsByTime);

        /**
         * <p>
         * The attributes that apply to a specific dimension value. For example, if the value is a linked account, the
         * attribute is that account name.
         * </p>
         * 
         * @param dimensionValueAttributes
         *        The attributes that apply to a specific dimension value. For example, if the value is a linked
         *        account, the attribute is that account name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionValueAttributes(Collection<DimensionValuesWithAttributes> dimensionValueAttributes);

        /**
         * <p>
         * The attributes that apply to a specific dimension value. For example, if the value is a linked account, the
         * attribute is that account name.
         * </p>
         * 
         * @param dimensionValueAttributes
         *        The attributes that apply to a specific dimension value. For example, if the value is a linked
         *        account, the attribute is that account name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionValueAttributes(DimensionValuesWithAttributes... dimensionValueAttributes);

        /**
         * <p>
         * The attributes that apply to a specific dimension value. For example, if the value is a linked account, the
         * attribute is that account name.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DimensionValuesWithAttributes>.Builder}
         * avoiding the need to create one manually via {@link List<DimensionValuesWithAttributes>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DimensionValuesWithAttributes>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #dimensionValueAttributes(List<DimensionValuesWithAttributes>)}.
         * 
         * @param dimensionValueAttributes
         *        a consumer that will call methods on {@link List<DimensionValuesWithAttributes>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dimensionValueAttributes(List<DimensionValuesWithAttributes>)
         */
        Builder dimensionValueAttributes(Consumer<DimensionValuesWithAttributes.Builder>... dimensionValueAttributes);
    }

    static final class BuilderImpl extends CostExplorerResponse.BuilderImpl implements Builder {
        private String nextPageToken;

        private List<GroupDefinition> groupDefinitions = DefaultSdkAutoConstructList.getInstance();

        private List<ResultByTime> resultsByTime = DefaultSdkAutoConstructList.getInstance();

        private List<DimensionValuesWithAttributes> dimensionValueAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetCostAndUsageWithResourcesResponse model) {
            super(model);
            nextPageToken(model.nextPageToken);
            groupDefinitions(model.groupDefinitions);
            resultsByTime(model.resultsByTime);
            dimensionValueAttributes(model.dimensionValueAttributes);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        public final Collection<GroupDefinition.Builder> getGroupDefinitions() {
            if (groupDefinitions instanceof SdkAutoConstructList) {
                return null;
            }
            return groupDefinitions != null ? groupDefinitions.stream().map(GroupDefinition::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder groupDefinitions(Collection<GroupDefinition> groupDefinitions) {
            this.groupDefinitions = GroupDefinitionsCopier.copy(groupDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupDefinitions(GroupDefinition... groupDefinitions) {
            groupDefinitions(Arrays.asList(groupDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupDefinitions(Consumer<GroupDefinition.Builder>... groupDefinitions) {
            groupDefinitions(Stream.of(groupDefinitions).map(c -> GroupDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setGroupDefinitions(Collection<GroupDefinition.BuilderImpl> groupDefinitions) {
            this.groupDefinitions = GroupDefinitionsCopier.copyFromBuilder(groupDefinitions);
        }

        public final Collection<ResultByTime.Builder> getResultsByTime() {
            if (resultsByTime instanceof SdkAutoConstructList) {
                return null;
            }
            return resultsByTime != null ? resultsByTime.stream().map(ResultByTime::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder resultsByTime(Collection<ResultByTime> resultsByTime) {
            this.resultsByTime = ResultsByTimeCopier.copy(resultsByTime);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultsByTime(ResultByTime... resultsByTime) {
            resultsByTime(Arrays.asList(resultsByTime));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultsByTime(Consumer<ResultByTime.Builder>... resultsByTime) {
            resultsByTime(Stream.of(resultsByTime).map(c -> ResultByTime.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setResultsByTime(Collection<ResultByTime.BuilderImpl> resultsByTime) {
            this.resultsByTime = ResultsByTimeCopier.copyFromBuilder(resultsByTime);
        }

        public final Collection<DimensionValuesWithAttributes.Builder> getDimensionValueAttributes() {
            if (dimensionValueAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return dimensionValueAttributes != null ? dimensionValueAttributes.stream()
                    .map(DimensionValuesWithAttributes::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dimensionValueAttributes(Collection<DimensionValuesWithAttributes> dimensionValueAttributes) {
            this.dimensionValueAttributes = DimensionValuesWithAttributesListCopier.copy(dimensionValueAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionValueAttributes(DimensionValuesWithAttributes... dimensionValueAttributes) {
            dimensionValueAttributes(Arrays.asList(dimensionValueAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionValueAttributes(Consumer<DimensionValuesWithAttributes.Builder>... dimensionValueAttributes) {
            dimensionValueAttributes(Stream.of(dimensionValueAttributes)
                    .map(c -> DimensionValuesWithAttributes.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDimensionValueAttributes(
                Collection<DimensionValuesWithAttributes.BuilderImpl> dimensionValueAttributes) {
            this.dimensionValueAttributes = DimensionValuesWithAttributesListCopier.copyFromBuilder(dimensionValueAttributes);
        }

        @Override
        public GetCostAndUsageWithResourcesResponse build() {
            return new GetCostAndUsageWithResourcesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
