/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.AnomalySubscription;
import software.amazon.awssdk.services.costexplorer.model.AnomalySubscriptionsCopier;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAnomalySubscriptionsResponse
extends CostExplorerResponse
implements ToCopyableBuilder<Builder, GetAnomalySubscriptionsResponse> {
    private static final SdkField<List<AnomalySubscription>> ANOMALY_SUBSCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AnomalySubscriptions").getter(GetAnomalySubscriptionsResponse.getter(GetAnomalySubscriptionsResponse::anomalySubscriptions)).setter(GetAnomalySubscriptionsResponse.setter(Builder::anomalySubscriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalySubscriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnomalySubscription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextPageToken").getter(GetAnomalySubscriptionsResponse.getter(GetAnomalySubscriptionsResponse::nextPageToken)).setter(GetAnomalySubscriptionsResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_SUBSCRIPTIONS_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private final List<AnomalySubscription> anomalySubscriptions;
    private final String nextPageToken;

    private GetAnomalySubscriptionsResponse(BuilderImpl builder) {
        super(builder);
        this.anomalySubscriptions = builder.anomalySubscriptions;
        this.nextPageToken = builder.nextPageToken;
    }

    public final boolean hasAnomalySubscriptions() {
        return this.anomalySubscriptions != null && !(this.anomalySubscriptions instanceof SdkAutoConstructList);
    }

    public final List<AnomalySubscription> anomalySubscriptions() {
        return this.anomalySubscriptions;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnomalySubscriptions() ? this.anomalySubscriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAnomalySubscriptionsResponse)) {
            return false;
        }
        GetAnomalySubscriptionsResponse other = (GetAnomalySubscriptionsResponse)((Object)obj);
        return this.hasAnomalySubscriptions() == other.hasAnomalySubscriptions() && Objects.equals(this.anomalySubscriptions(), other.anomalySubscriptions()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetAnomalySubscriptionsResponse").add("AnomalySubscriptions", this.hasAnomalySubscriptions() ? this.anomalySubscriptions() : null).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AnomalySubscriptions": {
                return Optional.ofNullable(clazz.cast(this.anomalySubscriptions()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAnomalySubscriptionsResponse, T> g) {
        return obj -> g.apply((GetAnomalySubscriptionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostExplorerResponse.BuilderImpl
    implements Builder {
        private List<AnomalySubscription> anomalySubscriptions = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAnomalySubscriptionsResponse model) {
            super(model);
            this.anomalySubscriptions(model.anomalySubscriptions);
            this.nextPageToken(model.nextPageToken);
        }

        public final Collection<AnomalySubscription.Builder> getAnomalySubscriptions() {
            if (this.anomalySubscriptions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.anomalySubscriptions != null ? (Collection)this.anomalySubscriptions.stream().map(AnomalySubscription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder anomalySubscriptions(Collection<AnomalySubscription> anomalySubscriptions) {
            this.anomalySubscriptions = AnomalySubscriptionsCopier.copy(anomalySubscriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder anomalySubscriptions(AnomalySubscription ... anomalySubscriptions) {
            this.anomalySubscriptions(Arrays.asList(anomalySubscriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder anomalySubscriptions(Consumer<AnomalySubscription.Builder> ... anomalySubscriptions) {
            this.anomalySubscriptions(Stream.of(anomalySubscriptions).map(c -> (AnomalySubscription)((AnomalySubscription.Builder)AnomalySubscription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAnomalySubscriptions(Collection<AnomalySubscription.BuilderImpl> anomalySubscriptions) {
            this.anomalySubscriptions = AnomalySubscriptionsCopier.copyFromBuilder(anomalySubscriptions);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetAnomalySubscriptionsResponse build() {
            return new GetAnomalySubscriptionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CostExplorerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAnomalySubscriptionsResponse> {
        public Builder anomalySubscriptions(Collection<AnomalySubscription> var1);

        public Builder anomalySubscriptions(AnomalySubscription ... var1);

        public Builder anomalySubscriptions(Consumer<AnomalySubscription.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

