/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.CostCategoryRule;
import software.amazon.awssdk.services.costexplorer.model.CostCategoryRuleVersion;
import software.amazon.awssdk.services.costexplorer.model.CostCategoryRulesListCopier;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateCostCategoryDefinitionRequest
extends CostExplorerRequest
implements ToCopyableBuilder<Builder, UpdateCostCategoryDefinitionRequest> {
    private static final SdkField<String> COST_CATEGORY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CostCategoryArn").getter(UpdateCostCategoryDefinitionRequest.getter(UpdateCostCategoryDefinitionRequest::costCategoryArn)).setter(UpdateCostCategoryDefinitionRequest.setter(Builder::costCategoryArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CostCategoryArn").build()}).build();
    private static final SdkField<String> RULE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleVersion").getter(UpdateCostCategoryDefinitionRequest.getter(UpdateCostCategoryDefinitionRequest::ruleVersionAsString)).setter(UpdateCostCategoryDefinitionRequest.setter(Builder::ruleVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleVersion").build()}).build();
    private static final SdkField<List<CostCategoryRule>> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Rules").getter(UpdateCostCategoryDefinitionRequest.getter(UpdateCostCategoryDefinitionRequest::rules)).setter(UpdateCostCategoryDefinitionRequest.setter(Builder::rules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CostCategoryRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COST_CATEGORY_ARN_FIELD, RULE_VERSION_FIELD, RULES_FIELD));
    private final String costCategoryArn;
    private final String ruleVersion;
    private final List<CostCategoryRule> rules;

    private UpdateCostCategoryDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.costCategoryArn = builder.costCategoryArn;
        this.ruleVersion = builder.ruleVersion;
        this.rules = builder.rules;
    }

    public String costCategoryArn() {
        return this.costCategoryArn;
    }

    public CostCategoryRuleVersion ruleVersion() {
        return CostCategoryRuleVersion.fromValue(this.ruleVersion);
    }

    public String ruleVersionAsString() {
        return this.ruleVersion;
    }

    public boolean hasRules() {
        return this.rules != null && !(this.rules instanceof SdkAutoConstructList);
    }

    public List<CostCategoryRule> rules() {
        return this.rules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.costCategoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRules() ? this.rules() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCostCategoryDefinitionRequest)) {
            return false;
        }
        UpdateCostCategoryDefinitionRequest other = (UpdateCostCategoryDefinitionRequest)((Object)obj);
        return Objects.equals(this.costCategoryArn(), other.costCategoryArn()) && Objects.equals(this.ruleVersionAsString(), other.ruleVersionAsString()) && this.hasRules() == other.hasRules() && Objects.equals(this.rules(), other.rules());
    }

    public String toString() {
        return ToString.builder((String)"UpdateCostCategoryDefinitionRequest").add("CostCategoryArn", (Object)this.costCategoryArn()).add("RuleVersion", (Object)this.ruleVersionAsString()).add("Rules", this.hasRules() ? this.rules() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CostCategoryArn": {
                return Optional.ofNullable(clazz.cast(this.costCategoryArn()));
            }
            case "RuleVersion": {
                return Optional.ofNullable(clazz.cast(this.ruleVersionAsString()));
            }
            case "Rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateCostCategoryDefinitionRequest, T> g) {
        return obj -> g.apply((UpdateCostCategoryDefinitionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostExplorerRequest.BuilderImpl
    implements Builder {
        private String costCategoryArn;
        private String ruleVersion;
        private List<CostCategoryRule> rules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCostCategoryDefinitionRequest model) {
            super(model);
            this.costCategoryArn(model.costCategoryArn);
            this.ruleVersion(model.ruleVersion);
            this.rules(model.rules);
        }

        public final String getCostCategoryArn() {
            return this.costCategoryArn;
        }

        @Override
        public final Builder costCategoryArn(String costCategoryArn) {
            this.costCategoryArn = costCategoryArn;
            return this;
        }

        public final void setCostCategoryArn(String costCategoryArn) {
            this.costCategoryArn = costCategoryArn;
        }

        public final String getRuleVersion() {
            return this.ruleVersion;
        }

        @Override
        public final Builder ruleVersion(String ruleVersion) {
            this.ruleVersion = ruleVersion;
            return this;
        }

        @Override
        public final Builder ruleVersion(CostCategoryRuleVersion ruleVersion) {
            this.ruleVersion(ruleVersion == null ? null : ruleVersion.toString());
            return this;
        }

        public final void setRuleVersion(String ruleVersion) {
            this.ruleVersion = ruleVersion;
        }

        public final Collection<CostCategoryRule.Builder> getRules() {
            if (this.rules instanceof SdkAutoConstructList) {
                return null;
            }
            return this.rules != null ? (Collection)this.rules.stream().map(CostCategoryRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rules(Collection<CostCategoryRule> rules) {
            this.rules = CostCategoryRulesListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(CostCategoryRule ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<CostCategoryRule.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (CostCategoryRule)((CostCategoryRule.Builder)CostCategoryRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRules(Collection<CostCategoryRule.BuilderImpl> rules) {
            this.rules = CostCategoryRulesListCopier.copyFromBuilder(rules);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCostCategoryDefinitionRequest build() {
            return new UpdateCostCategoryDefinitionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CostExplorerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateCostCategoryDefinitionRequest> {
        public Builder costCategoryArn(String var1);

        public Builder ruleVersion(String var1);

        public Builder ruleVersion(CostCategoryRuleVersion var1);

        public Builder rules(Collection<CostCategoryRule> var1);

        public Builder rules(CostCategoryRule ... var1);

        public Builder rules(Consumer<CostCategoryRule.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

