/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.AnomalySubscriptionFrequency;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerRequest;
import software.amazon.awssdk.services.costexplorer.model.Subscriber;
import software.amazon.awssdk.services.costexplorer.model.SubscribersCopier;
import software.amazon.awssdk.services.costexplorer.model.ValuesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAnomalySubscriptionRequest
extends CostExplorerRequest
implements ToCopyableBuilder<Builder, UpdateAnomalySubscriptionRequest> {
    private static final SdkField<String> SUBSCRIPTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubscriptionArn").getter(UpdateAnomalySubscriptionRequest.getter(UpdateAnomalySubscriptionRequest::subscriptionArn)).setter(UpdateAnomalySubscriptionRequest.setter(Builder::subscriptionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionArn").build()}).build();
    private static final SdkField<Double> THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Threshold").getter(UpdateAnomalySubscriptionRequest.getter(UpdateAnomalySubscriptionRequest::threshold)).setter(UpdateAnomalySubscriptionRequest.setter(Builder::threshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Threshold").build()}).build();
    private static final SdkField<String> FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Frequency").getter(UpdateAnomalySubscriptionRequest.getter(UpdateAnomalySubscriptionRequest::frequencyAsString)).setter(UpdateAnomalySubscriptionRequest.setter(Builder::frequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Frequency").build()}).build();
    private static final SdkField<List<String>> MONITOR_ARN_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MonitorArnList").getter(UpdateAnomalySubscriptionRequest.getter(UpdateAnomalySubscriptionRequest::monitorArnList)).setter(UpdateAnomalySubscriptionRequest.setter(Builder::monitorArnList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitorArnList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Subscriber>> SUBSCRIBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Subscribers").getter(UpdateAnomalySubscriptionRequest.getter(UpdateAnomalySubscriptionRequest::subscribers)).setter(UpdateAnomalySubscriptionRequest.setter(Builder::subscribers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subscribers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Subscriber::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SUBSCRIPTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubscriptionName").getter(UpdateAnomalySubscriptionRequest.getter(UpdateAnomalySubscriptionRequest::subscriptionName)).setter(UpdateAnomalySubscriptionRequest.setter(Builder::subscriptionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBSCRIPTION_ARN_FIELD, THRESHOLD_FIELD, FREQUENCY_FIELD, MONITOR_ARN_LIST_FIELD, SUBSCRIBERS_FIELD, SUBSCRIPTION_NAME_FIELD));
    private final String subscriptionArn;
    private final Double threshold;
    private final String frequency;
    private final List<String> monitorArnList;
    private final List<Subscriber> subscribers;
    private final String subscriptionName;

    private UpdateAnomalySubscriptionRequest(BuilderImpl builder) {
        super(builder);
        this.subscriptionArn = builder.subscriptionArn;
        this.threshold = builder.threshold;
        this.frequency = builder.frequency;
        this.monitorArnList = builder.monitorArnList;
        this.subscribers = builder.subscribers;
        this.subscriptionName = builder.subscriptionName;
    }

    public String subscriptionArn() {
        return this.subscriptionArn;
    }

    public Double threshold() {
        return this.threshold;
    }

    public AnomalySubscriptionFrequency frequency() {
        return AnomalySubscriptionFrequency.fromValue(this.frequency);
    }

    public String frequencyAsString() {
        return this.frequency;
    }

    public boolean hasMonitorArnList() {
        return this.monitorArnList != null && !(this.monitorArnList instanceof SdkAutoConstructList);
    }

    public List<String> monitorArnList() {
        return this.monitorArnList;
    }

    public boolean hasSubscribers() {
        return this.subscribers != null && !(this.subscribers instanceof SdkAutoConstructList);
    }

    public List<Subscriber> subscribers() {
        return this.subscribers;
    }

    public String subscriptionName() {
        return this.subscriptionName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.threshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.frequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitorArnList());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscribers());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAnomalySubscriptionRequest)) {
            return false;
        }
        UpdateAnomalySubscriptionRequest other = (UpdateAnomalySubscriptionRequest)((Object)obj);
        return Objects.equals(this.subscriptionArn(), other.subscriptionArn()) && Objects.equals(this.threshold(), other.threshold()) && Objects.equals(this.frequencyAsString(), other.frequencyAsString()) && Objects.equals(this.monitorArnList(), other.monitorArnList()) && Objects.equals(this.subscribers(), other.subscribers()) && Objects.equals(this.subscriptionName(), other.subscriptionName());
    }

    public String toString() {
        return ToString.builder((String)"UpdateAnomalySubscriptionRequest").add("SubscriptionArn", (Object)this.subscriptionArn()).add("Threshold", (Object)this.threshold()).add("Frequency", (Object)this.frequencyAsString()).add("MonitorArnList", this.monitorArnList()).add("Subscribers", this.subscribers()).add("SubscriptionName", (Object)this.subscriptionName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubscriptionArn": {
                return Optional.ofNullable(clazz.cast(this.subscriptionArn()));
            }
            case "Threshold": {
                return Optional.ofNullable(clazz.cast(this.threshold()));
            }
            case "Frequency": {
                return Optional.ofNullable(clazz.cast(this.frequencyAsString()));
            }
            case "MonitorArnList": {
                return Optional.ofNullable(clazz.cast(this.monitorArnList()));
            }
            case "Subscribers": {
                return Optional.ofNullable(clazz.cast(this.subscribers()));
            }
            case "SubscriptionName": {
                return Optional.ofNullable(clazz.cast(this.subscriptionName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAnomalySubscriptionRequest, T> g) {
        return obj -> g.apply((UpdateAnomalySubscriptionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostExplorerRequest.BuilderImpl
    implements Builder {
        private String subscriptionArn;
        private Double threshold;
        private String frequency;
        private List<String> monitorArnList = DefaultSdkAutoConstructList.getInstance();
        private List<Subscriber> subscribers = DefaultSdkAutoConstructList.getInstance();
        private String subscriptionName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAnomalySubscriptionRequest model) {
            super(model);
            this.subscriptionArn(model.subscriptionArn);
            this.threshold(model.threshold);
            this.frequency(model.frequency);
            this.monitorArnList(model.monitorArnList);
            this.subscribers(model.subscribers);
            this.subscriptionName(model.subscriptionName);
        }

        public final String getSubscriptionArn() {
            return this.subscriptionArn;
        }

        @Override
        public final Builder subscriptionArn(String subscriptionArn) {
            this.subscriptionArn = subscriptionArn;
            return this;
        }

        public final void setSubscriptionArn(String subscriptionArn) {
            this.subscriptionArn = subscriptionArn;
        }

        public final Double getThreshold() {
            return this.threshold;
        }

        @Override
        public final Builder threshold(Double threshold) {
            this.threshold = threshold;
            return this;
        }

        public final void setThreshold(Double threshold) {
            this.threshold = threshold;
        }

        public final String getFrequency() {
            return this.frequency;
        }

        @Override
        public final Builder frequency(String frequency) {
            this.frequency = frequency;
            return this;
        }

        @Override
        public final Builder frequency(AnomalySubscriptionFrequency frequency) {
            this.frequency(frequency == null ? null : frequency.toString());
            return this;
        }

        public final void setFrequency(String frequency) {
            this.frequency = frequency;
        }

        public final Collection<String> getMonitorArnList() {
            return this.monitorArnList;
        }

        @Override
        public final Builder monitorArnList(Collection<String> monitorArnList) {
            this.monitorArnList = ValuesCopier.copy(monitorArnList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder monitorArnList(String ... monitorArnList) {
            this.monitorArnList(Arrays.asList(monitorArnList));
            return this;
        }

        public final void setMonitorArnList(Collection<String> monitorArnList) {
            this.monitorArnList = ValuesCopier.copy(monitorArnList);
        }

        public final Collection<Subscriber.Builder> getSubscribers() {
            return this.subscribers != null ? (Collection)this.subscribers.stream().map(Subscriber::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder subscribers(Collection<Subscriber> subscribers) {
            this.subscribers = SubscribersCopier.copy(subscribers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribers(Subscriber ... subscribers) {
            this.subscribers(Arrays.asList(subscribers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribers(Consumer<Subscriber.Builder> ... subscribers) {
            this.subscribers(Stream.of(subscribers).map(c -> (Subscriber)((Subscriber.Builder)Subscriber.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSubscribers(Collection<Subscriber.BuilderImpl> subscribers) {
            this.subscribers = SubscribersCopier.copyFromBuilder(subscribers);
        }

        public final String getSubscriptionName() {
            return this.subscriptionName;
        }

        @Override
        public final Builder subscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
            return this;
        }

        public final void setSubscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAnomalySubscriptionRequest build() {
            return new UpdateAnomalySubscriptionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CostExplorerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAnomalySubscriptionRequest> {
        public Builder subscriptionArn(String var1);

        public Builder threshold(Double var1);

        public Builder frequency(String var1);

        public Builder frequency(AnomalySubscriptionFrequency var1);

        public Builder monitorArnList(Collection<String> var1);

        public Builder monitorArnList(String ... var1);

        public Builder subscribers(Collection<Subscriber> var1);

        public Builder subscribers(Subscriber ... var1);

        public Builder subscribers(Consumer<Subscriber.Builder> ... var1);

        public Builder subscriptionName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

