/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.costexplorer.model.SavingsPlansAmortizedCommitment;
import software.amazon.awssdk.services.costexplorer.model.SavingsPlansSavings;
import software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilization;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SavingsPlansUtilizationAggregates
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SavingsPlansUtilizationAggregates> {
    private static final SdkField<SavingsPlansUtilization> UTILIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Utilization").getter(SavingsPlansUtilizationAggregates.getter(SavingsPlansUtilizationAggregates::utilization)).setter(SavingsPlansUtilizationAggregates.setter(Builder::utilization)).constructor(SavingsPlansUtilization::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Utilization").build()}).build();
    private static final SdkField<SavingsPlansSavings> SAVINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Savings").getter(SavingsPlansUtilizationAggregates.getter(SavingsPlansUtilizationAggregates::savings)).setter(SavingsPlansUtilizationAggregates.setter(Builder::savings)).constructor(SavingsPlansSavings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Savings").build()}).build();
    private static final SdkField<SavingsPlansAmortizedCommitment> AMORTIZED_COMMITMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AmortizedCommitment").getter(SavingsPlansUtilizationAggregates.getter(SavingsPlansUtilizationAggregates::amortizedCommitment)).setter(SavingsPlansUtilizationAggregates.setter(Builder::amortizedCommitment)).constructor(SavingsPlansAmortizedCommitment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmortizedCommitment").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UTILIZATION_FIELD, SAVINGS_FIELD, AMORTIZED_COMMITMENT_FIELD));
    private static final long serialVersionUID = 1L;
    private final SavingsPlansUtilization utilization;
    private final SavingsPlansSavings savings;
    private final SavingsPlansAmortizedCommitment amortizedCommitment;

    private SavingsPlansUtilizationAggregates(BuilderImpl builder) {
        this.utilization = builder.utilization;
        this.savings = builder.savings;
        this.amortizedCommitment = builder.amortizedCommitment;
    }

    public SavingsPlansUtilization utilization() {
        return this.utilization;
    }

    public SavingsPlansSavings savings() {
        return this.savings;
    }

    public SavingsPlansAmortizedCommitment amortizedCommitment() {
        return this.amortizedCommitment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.utilization());
        hashCode = 31 * hashCode + Objects.hashCode(this.savings());
        hashCode = 31 * hashCode + Objects.hashCode(this.amortizedCommitment());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SavingsPlansUtilizationAggregates)) {
            return false;
        }
        SavingsPlansUtilizationAggregates other = (SavingsPlansUtilizationAggregates)obj;
        return Objects.equals(this.utilization(), other.utilization()) && Objects.equals(this.savings(), other.savings()) && Objects.equals(this.amortizedCommitment(), other.amortizedCommitment());
    }

    public String toString() {
        return ToString.builder((String)"SavingsPlansUtilizationAggregates").add("Utilization", (Object)this.utilization()).add("Savings", (Object)this.savings()).add("AmortizedCommitment", (Object)this.amortizedCommitment()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Utilization": {
                return Optional.ofNullable(clazz.cast(this.utilization()));
            }
            case "Savings": {
                return Optional.ofNullable(clazz.cast(this.savings()));
            }
            case "AmortizedCommitment": {
                return Optional.ofNullable(clazz.cast(this.amortizedCommitment()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SavingsPlansUtilizationAggregates, T> g) {
        return obj -> g.apply((SavingsPlansUtilizationAggregates)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SavingsPlansUtilization utilization;
        private SavingsPlansSavings savings;
        private SavingsPlansAmortizedCommitment amortizedCommitment;

        private BuilderImpl() {
        }

        private BuilderImpl(SavingsPlansUtilizationAggregates model) {
            this.utilization(model.utilization);
            this.savings(model.savings);
            this.amortizedCommitment(model.amortizedCommitment);
        }

        public final SavingsPlansUtilization.Builder getUtilization() {
            return this.utilization != null ? this.utilization.toBuilder() : null;
        }

        @Override
        public final Builder utilization(SavingsPlansUtilization utilization) {
            this.utilization = utilization;
            return this;
        }

        public final void setUtilization(SavingsPlansUtilization.BuilderImpl utilization) {
            this.utilization = utilization != null ? utilization.build() : null;
        }

        public final SavingsPlansSavings.Builder getSavings() {
            return this.savings != null ? this.savings.toBuilder() : null;
        }

        @Override
        public final Builder savings(SavingsPlansSavings savings) {
            this.savings = savings;
            return this;
        }

        public final void setSavings(SavingsPlansSavings.BuilderImpl savings) {
            this.savings = savings != null ? savings.build() : null;
        }

        public final SavingsPlansAmortizedCommitment.Builder getAmortizedCommitment() {
            return this.amortizedCommitment != null ? this.amortizedCommitment.toBuilder() : null;
        }

        @Override
        public final Builder amortizedCommitment(SavingsPlansAmortizedCommitment amortizedCommitment) {
            this.amortizedCommitment = amortizedCommitment;
            return this;
        }

        public final void setAmortizedCommitment(SavingsPlansAmortizedCommitment.BuilderImpl amortizedCommitment) {
            this.amortizedCommitment = amortizedCommitment != null ? amortizedCommitment.build() : null;
        }

        public SavingsPlansUtilizationAggregates build() {
            return new SavingsPlansUtilizationAggregates(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SavingsPlansUtilizationAggregates> {
        public Builder utilization(SavingsPlansUtilization var1);

        default public Builder utilization(Consumer<SavingsPlansUtilization.Builder> utilization) {
            return this.utilization((SavingsPlansUtilization)((SavingsPlansUtilization.Builder)SavingsPlansUtilization.builder().applyMutation(utilization)).build());
        }

        public Builder savings(SavingsPlansSavings var1);

        default public Builder savings(Consumer<SavingsPlansSavings.Builder> savings) {
            return this.savings((SavingsPlansSavings)((SavingsPlansSavings.Builder)SavingsPlansSavings.builder().applyMutation(savings)).build());
        }

        public Builder amortizedCommitment(SavingsPlansAmortizedCommitment var1);

        default public Builder amortizedCommitment(Consumer<SavingsPlansAmortizedCommitment.Builder> amortizedCommitment) {
            return this.amortizedCommitment((SavingsPlansAmortizedCommitment)((SavingsPlansAmortizedCommitment.Builder)SavingsPlansAmortizedCommitment.builder().applyMutation(amortizedCommitment)).build());
        }
    }
}

