/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.MatchOption;
import software.amazon.awssdk.services.costexplorer.model.MatchOptionsCopier;
import software.amazon.awssdk.services.costexplorer.model.ValuesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TagValues
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TagValues> {
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TagValues.getter(TagValues::key)).setter(TagValues.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()}).build();
    private static final SdkField<List<String>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(TagValues.getter(TagValues::values)).setter(TagValues.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> MATCH_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(TagValues.getter(TagValues::matchOptionsAsStrings)).setter(TagValues.setter(Builder::matchOptionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, VALUES_FIELD, MATCH_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String key;
    private final List<String> values;
    private final List<String> matchOptions;

    private TagValues(BuilderImpl builder) {
        this.key = builder.key;
        this.values = builder.values;
        this.matchOptions = builder.matchOptions;
    }

    public String key() {
        return this.key;
    }

    public boolean hasValues() {
        return this.values != null && !(this.values instanceof SdkAutoConstructList);
    }

    public List<String> values() {
        return this.values;
    }

    public List<MatchOption> matchOptions() {
        return MatchOptionsCopier.copyStringToEnum(this.matchOptions);
    }

    public boolean hasMatchOptions() {
        return this.matchOptions != null && !(this.matchOptions instanceof SdkAutoConstructList);
    }

    public List<String> matchOptionsAsStrings() {
        return this.matchOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.values());
        hashCode = 31 * hashCode + Objects.hashCode(this.matchOptionsAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagValues)) {
            return false;
        }
        TagValues other = (TagValues)obj;
        return Objects.equals(this.key(), other.key()) && Objects.equals(this.values(), other.values()) && Objects.equals(this.matchOptionsAsStrings(), other.matchOptionsAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"TagValues").add("Key", (Object)this.key()).add("Values", this.values()).add("MatchOptions", this.matchOptionsAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "Values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
            case "MatchOptions": {
                return Optional.ofNullable(clazz.cast(this.matchOptionsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TagValues, T> g) {
        return obj -> g.apply((TagValues)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String key;
        private List<String> values = DefaultSdkAutoConstructList.getInstance();
        private List<String> matchOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TagValues model) {
            this.key(model.key);
            this.values(model.values);
            this.matchOptionsWithStrings(model.matchOptions);
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final Collection<String> getValues() {
            return this.values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = ValuesCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = ValuesCopier.copy(values);
        }

        public final Collection<String> getMatchOptions() {
            return this.matchOptions;
        }

        @Override
        public final Builder matchOptionsWithStrings(Collection<String> matchOptions) {
            this.matchOptions = MatchOptionsCopier.copy(matchOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchOptionsWithStrings(String ... matchOptions) {
            this.matchOptionsWithStrings(Arrays.asList(matchOptions));
            return this;
        }

        @Override
        public final Builder matchOptions(Collection<MatchOption> matchOptions) {
            this.matchOptions = MatchOptionsCopier.copyEnumToString(matchOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchOptions(MatchOption ... matchOptions) {
            this.matchOptions(Arrays.asList(matchOptions));
            return this;
        }

        public final void setMatchOptions(Collection<String> matchOptions) {
            this.matchOptions = MatchOptionsCopier.copy(matchOptions);
        }

        public TagValues build() {
            return new TagValues(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TagValues> {
        public Builder key(String var1);

        public Builder values(Collection<String> var1);

        public Builder values(String ... var1);

        public Builder matchOptionsWithStrings(Collection<String> var1);

        public Builder matchOptionsWithStrings(String ... var1);

        public Builder matchOptions(Collection<MatchOption> var1);

        public Builder matchOptions(MatchOption ... var1);
    }
}

