/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.costexplorer.model.RecommendationTarget;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RightsizingRecommendationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RightsizingRecommendationConfiguration> {
    private static final SdkField<String> RECOMMENDATION_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RightsizingRecommendationConfiguration.getter(RightsizingRecommendationConfiguration::recommendationTargetAsString)).setter(RightsizingRecommendationConfiguration.setter(Builder::recommendationTarget)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationTarget").build()}).build();
    private static final SdkField<Boolean> BENEFITS_CONSIDERED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(RightsizingRecommendationConfiguration.getter(RightsizingRecommendationConfiguration::benefitsConsidered)).setter(RightsizingRecommendationConfiguration.setter(Builder::benefitsConsidered)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BenefitsConsidered").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDATION_TARGET_FIELD, BENEFITS_CONSIDERED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String recommendationTarget;
    private final Boolean benefitsConsidered;

    private RightsizingRecommendationConfiguration(BuilderImpl builder) {
        this.recommendationTarget = builder.recommendationTarget;
        this.benefitsConsidered = builder.benefitsConsidered;
    }

    public RecommendationTarget recommendationTarget() {
        return RecommendationTarget.fromValue(this.recommendationTarget);
    }

    public String recommendationTargetAsString() {
        return this.recommendationTarget;
    }

    public Boolean benefitsConsidered() {
        return this.benefitsConsidered;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationTargetAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.benefitsConsidered());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RightsizingRecommendationConfiguration)) {
            return false;
        }
        RightsizingRecommendationConfiguration other = (RightsizingRecommendationConfiguration)obj;
        return Objects.equals(this.recommendationTargetAsString(), other.recommendationTargetAsString()) && Objects.equals(this.benefitsConsidered(), other.benefitsConsidered());
    }

    public String toString() {
        return ToString.builder((String)"RightsizingRecommendationConfiguration").add("RecommendationTarget", (Object)this.recommendationTargetAsString()).add("BenefitsConsidered", (Object)this.benefitsConsidered()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecommendationTarget": {
                return Optional.ofNullable(clazz.cast(this.recommendationTargetAsString()));
            }
            case "BenefitsConsidered": {
                return Optional.ofNullable(clazz.cast(this.benefitsConsidered()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RightsizingRecommendationConfiguration, T> g) {
        return obj -> g.apply((RightsizingRecommendationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String recommendationTarget;
        private Boolean benefitsConsidered;

        private BuilderImpl() {
        }

        private BuilderImpl(RightsizingRecommendationConfiguration model) {
            this.recommendationTarget(model.recommendationTarget);
            this.benefitsConsidered(model.benefitsConsidered);
        }

        public final String getRecommendationTarget() {
            return this.recommendationTarget;
        }

        @Override
        public final Builder recommendationTarget(String recommendationTarget) {
            this.recommendationTarget = recommendationTarget;
            return this;
        }

        @Override
        public final Builder recommendationTarget(RecommendationTarget recommendationTarget) {
            this.recommendationTarget(recommendationTarget == null ? null : recommendationTarget.toString());
            return this;
        }

        public final void setRecommendationTarget(String recommendationTarget) {
            this.recommendationTarget = recommendationTarget;
        }

        public final Boolean getBenefitsConsidered() {
            return this.benefitsConsidered;
        }

        @Override
        public final Builder benefitsConsidered(Boolean benefitsConsidered) {
            this.benefitsConsidered = benefitsConsidered;
            return this;
        }

        public final void setBenefitsConsidered(Boolean benefitsConsidered) {
            this.benefitsConsidered = benefitsConsidered;
        }

        public RightsizingRecommendationConfiguration build() {
            return new RightsizingRecommendationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RightsizingRecommendationConfiguration> {
        public Builder recommendationTarget(String var1);

        public Builder recommendationTarget(RecommendationTarget var1);

        public Builder benefitsConsidered(Boolean var1);
    }
}

