/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerResponse;
import software.amazon.awssdk.services.costexplorer.model.DateInterval;
import software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilizationAggregates;
import software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilizationDetail;
import software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilizationDetailsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSavingsPlansUtilizationDetailsResponse
extends CostExplorerResponse
implements ToCopyableBuilder<Builder, GetSavingsPlansUtilizationDetailsResponse> {
    private static final SdkField<List<SavingsPlansUtilizationDetail>> SAVINGS_PLANS_UTILIZATION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetSavingsPlansUtilizationDetailsResponse.getter(GetSavingsPlansUtilizationDetailsResponse::savingsPlansUtilizationDetails)).setter(GetSavingsPlansUtilizationDetailsResponse.setter(Builder::savingsPlansUtilizationDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SavingsPlansUtilizationDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SavingsPlansUtilizationDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SavingsPlansUtilizationAggregates> TOTAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetSavingsPlansUtilizationDetailsResponse.getter(GetSavingsPlansUtilizationDetailsResponse::total)).setter(GetSavingsPlansUtilizationDetailsResponse.setter(Builder::total)).constructor(SavingsPlansUtilizationAggregates::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Total").build()}).build();
    private static final SdkField<DateInterval> TIME_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetSavingsPlansUtilizationDetailsResponse.getter(GetSavingsPlansUtilizationDetailsResponse::timePeriod)).setter(GetSavingsPlansUtilizationDetailsResponse.setter(Builder::timePeriod)).constructor(DateInterval::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimePeriod").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetSavingsPlansUtilizationDetailsResponse.getter(GetSavingsPlansUtilizationDetailsResponse::nextToken)).setter(GetSavingsPlansUtilizationDetailsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAVINGS_PLANS_UTILIZATION_DETAILS_FIELD, TOTAL_FIELD, TIME_PERIOD_FIELD, NEXT_TOKEN_FIELD));
    private final List<SavingsPlansUtilizationDetail> savingsPlansUtilizationDetails;
    private final SavingsPlansUtilizationAggregates total;
    private final DateInterval timePeriod;
    private final String nextToken;

    private GetSavingsPlansUtilizationDetailsResponse(BuilderImpl builder) {
        super(builder);
        this.savingsPlansUtilizationDetails = builder.savingsPlansUtilizationDetails;
        this.total = builder.total;
        this.timePeriod = builder.timePeriod;
        this.nextToken = builder.nextToken;
    }

    public boolean hasSavingsPlansUtilizationDetails() {
        return this.savingsPlansUtilizationDetails != null && !(this.savingsPlansUtilizationDetails instanceof SdkAutoConstructList);
    }

    public List<SavingsPlansUtilizationDetail> savingsPlansUtilizationDetails() {
        return this.savingsPlansUtilizationDetails;
    }

    public SavingsPlansUtilizationAggregates total() {
        return this.total;
    }

    public DateInterval timePeriod() {
        return this.timePeriod;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.savingsPlansUtilizationDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.total());
        hashCode = 31 * hashCode + Objects.hashCode(this.timePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSavingsPlansUtilizationDetailsResponse)) {
            return false;
        }
        GetSavingsPlansUtilizationDetailsResponse other = (GetSavingsPlansUtilizationDetailsResponse)((Object)obj);
        return Objects.equals(this.savingsPlansUtilizationDetails(), other.savingsPlansUtilizationDetails()) && Objects.equals(this.total(), other.total()) && Objects.equals(this.timePeriod(), other.timePeriod()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"GetSavingsPlansUtilizationDetailsResponse").add("SavingsPlansUtilizationDetails", this.savingsPlansUtilizationDetails()).add("Total", (Object)this.total()).add("TimePeriod", (Object)this.timePeriod()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SavingsPlansUtilizationDetails": {
                return Optional.ofNullable(clazz.cast(this.savingsPlansUtilizationDetails()));
            }
            case "Total": {
                return Optional.ofNullable(clazz.cast(this.total()));
            }
            case "TimePeriod": {
                return Optional.ofNullable(clazz.cast(this.timePeriod()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSavingsPlansUtilizationDetailsResponse, T> g) {
        return obj -> g.apply((GetSavingsPlansUtilizationDetailsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostExplorerResponse.BuilderImpl
    implements Builder {
        private List<SavingsPlansUtilizationDetail> savingsPlansUtilizationDetails = DefaultSdkAutoConstructList.getInstance();
        private SavingsPlansUtilizationAggregates total;
        private DateInterval timePeriod;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSavingsPlansUtilizationDetailsResponse model) {
            super(model);
            this.savingsPlansUtilizationDetails(model.savingsPlansUtilizationDetails);
            this.total(model.total);
            this.timePeriod(model.timePeriod);
            this.nextToken(model.nextToken);
        }

        public final Collection<SavingsPlansUtilizationDetail.Builder> getSavingsPlansUtilizationDetails() {
            return this.savingsPlansUtilizationDetails != null ? (Collection)this.savingsPlansUtilizationDetails.stream().map(SavingsPlansUtilizationDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder savingsPlansUtilizationDetails(Collection<SavingsPlansUtilizationDetail> savingsPlansUtilizationDetails) {
            this.savingsPlansUtilizationDetails = SavingsPlansUtilizationDetailsCopier.copy(savingsPlansUtilizationDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder savingsPlansUtilizationDetails(SavingsPlansUtilizationDetail ... savingsPlansUtilizationDetails) {
            this.savingsPlansUtilizationDetails(Arrays.asList(savingsPlansUtilizationDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder savingsPlansUtilizationDetails(Consumer<SavingsPlansUtilizationDetail.Builder> ... savingsPlansUtilizationDetails) {
            this.savingsPlansUtilizationDetails(Stream.of(savingsPlansUtilizationDetails).map(c -> (SavingsPlansUtilizationDetail)((SavingsPlansUtilizationDetail.Builder)SavingsPlansUtilizationDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSavingsPlansUtilizationDetails(Collection<SavingsPlansUtilizationDetail.BuilderImpl> savingsPlansUtilizationDetails) {
            this.savingsPlansUtilizationDetails = SavingsPlansUtilizationDetailsCopier.copyFromBuilder(savingsPlansUtilizationDetails);
        }

        public final SavingsPlansUtilizationAggregates.Builder getTotal() {
            return this.total != null ? this.total.toBuilder() : null;
        }

        @Override
        public final Builder total(SavingsPlansUtilizationAggregates total) {
            this.total = total;
            return this;
        }

        public final void setTotal(SavingsPlansUtilizationAggregates.BuilderImpl total) {
            this.total = total != null ? total.build() : null;
        }

        public final DateInterval.Builder getTimePeriod() {
            return this.timePeriod != null ? this.timePeriod.toBuilder() : null;
        }

        @Override
        public final Builder timePeriod(DateInterval timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        public final void setTimePeriod(DateInterval.BuilderImpl timePeriod) {
            this.timePeriod = timePeriod != null ? timePeriod.build() : null;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetSavingsPlansUtilizationDetailsResponse build() {
            return new GetSavingsPlansUtilizationDetailsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CostExplorerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSavingsPlansUtilizationDetailsResponse> {
        public Builder savingsPlansUtilizationDetails(Collection<SavingsPlansUtilizationDetail> var1);

        public Builder savingsPlansUtilizationDetails(SavingsPlansUtilizationDetail ... var1);

        public Builder savingsPlansUtilizationDetails(Consumer<SavingsPlansUtilizationDetail.Builder> ... var1);

        public Builder total(SavingsPlansUtilizationAggregates var1);

        default public Builder total(Consumer<SavingsPlansUtilizationAggregates.Builder> total) {
            return this.total((SavingsPlansUtilizationAggregates)((SavingsPlansUtilizationAggregates.Builder)SavingsPlansUtilizationAggregates.builder().applyMutation(total)).build());
        }

        public Builder timePeriod(DateInterval var1);

        default public Builder timePeriod(Consumer<DateInterval.Builder> timePeriod) {
            return this.timePeriod((DateInterval)((DateInterval.Builder)DateInterval.builder().applyMutation(timePeriod)).build());
        }

        public Builder nextToken(String var1);
    }
}

