/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costandusagereport.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.costandusagereport.model.LastStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReportStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReportStatus> {
    private static final SdkField<String> LAST_DELIVERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastDelivery").getter(ReportStatus.getter(ReportStatus::lastDelivery)).setter(ReportStatus.setter(Builder::lastDelivery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastDelivery").build()}).build();
    private static final SdkField<String> LAST_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastStatus").getter(ReportStatus.getter(ReportStatus::lastStatusAsString)).setter(ReportStatus.setter(Builder::lastStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAST_DELIVERY_FIELD, LAST_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String lastDelivery;
    private final String lastStatus;

    private ReportStatus(BuilderImpl builder) {
        this.lastDelivery = builder.lastDelivery;
        this.lastStatus = builder.lastStatus;
    }

    public final String lastDelivery() {
        return this.lastDelivery;
    }

    public final LastStatus lastStatus() {
        return LastStatus.fromValue(this.lastStatus);
    }

    public final String lastStatusAsString() {
        return this.lastStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lastDelivery());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportStatus)) {
            return false;
        }
        ReportStatus other = (ReportStatus)obj;
        return Objects.equals(this.lastDelivery(), other.lastDelivery()) && Objects.equals(this.lastStatusAsString(), other.lastStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ReportStatus").add("LastDelivery", (Object)this.lastDelivery()).add("LastStatus", (Object)this.lastStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "lastDelivery": {
                return Optional.ofNullable(clazz.cast(this.lastDelivery()));
            }
            case "lastStatus": {
                return Optional.ofNullable(clazz.cast(this.lastStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReportStatus, T> g) {
        return obj -> g.apply((ReportStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String lastDelivery;
        private String lastStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportStatus model) {
            this.lastDelivery(model.lastDelivery);
            this.lastStatus(model.lastStatus);
        }

        public final String getLastDelivery() {
            return this.lastDelivery;
        }

        public final void setLastDelivery(String lastDelivery) {
            this.lastDelivery = lastDelivery;
        }

        @Override
        public final Builder lastDelivery(String lastDelivery) {
            this.lastDelivery = lastDelivery;
            return this;
        }

        public final String getLastStatus() {
            return this.lastStatus;
        }

        public final void setLastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
        }

        @Override
        public final Builder lastStatus(String lastStatus) {
            this.lastStatus = lastStatus;
            return this;
        }

        @Override
        public final Builder lastStatus(LastStatus lastStatus) {
            this.lastStatus(lastStatus == null ? null : lastStatus.toString());
            return this;
        }

        public ReportStatus build() {
            return new ReportStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReportStatus> {
        public Builder lastDelivery(String var1);

        public Builder lastStatus(String var1);

        public Builder lastStatus(LastStatus var1);
    }
}

