/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controltower.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.controltower.model.ControlTowerRequest;
import software.amazon.awssdk.services.controltower.model.EnabledBaselineParameter;
import software.amazon.awssdk.services.controltower.model.EnabledBaselineParametersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateEnabledBaselineRequest
extends ControlTowerRequest
implements ToCopyableBuilder<Builder, UpdateEnabledBaselineRequest> {
    private static final SdkField<String> BASELINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("baselineVersion").getter(UpdateEnabledBaselineRequest.getter(UpdateEnabledBaselineRequest::baselineVersion)).setter(UpdateEnabledBaselineRequest.setter(Builder::baselineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baselineVersion").build()}).build();
    private static final SdkField<String> ENABLED_BASELINE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("enabledBaselineIdentifier").getter(UpdateEnabledBaselineRequest.getter(UpdateEnabledBaselineRequest::enabledBaselineIdentifier)).setter(UpdateEnabledBaselineRequest.setter(Builder::enabledBaselineIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabledBaselineIdentifier").build()}).build();
    private static final SdkField<List<EnabledBaselineParameter>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("parameters").getter(UpdateEnabledBaselineRequest.getter(UpdateEnabledBaselineRequest::parameters)).setter(UpdateEnabledBaselineRequest.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EnabledBaselineParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASELINE_VERSION_FIELD, ENABLED_BASELINE_IDENTIFIER_FIELD, PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateEnabledBaselineRequest.memberNameToFieldInitializer();
    private final String baselineVersion;
    private final String enabledBaselineIdentifier;
    private final List<EnabledBaselineParameter> parameters;

    private UpdateEnabledBaselineRequest(BuilderImpl builder) {
        super(builder);
        this.baselineVersion = builder.baselineVersion;
        this.enabledBaselineIdentifier = builder.enabledBaselineIdentifier;
        this.parameters = builder.parameters;
    }

    public final String baselineVersion() {
        return this.baselineVersion;
    }

    public final String enabledBaselineIdentifier() {
        return this.enabledBaselineIdentifier;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructList);
    }

    public final List<EnabledBaselineParameter> parameters() {
        return this.parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.baselineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabledBaselineIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEnabledBaselineRequest)) {
            return false;
        }
        UpdateEnabledBaselineRequest other = (UpdateEnabledBaselineRequest)((Object)obj);
        return Objects.equals(this.baselineVersion(), other.baselineVersion()) && Objects.equals(this.enabledBaselineIdentifier(), other.enabledBaselineIdentifier()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateEnabledBaselineRequest").add("BaselineVersion", (Object)this.baselineVersion()).add("EnabledBaselineIdentifier", (Object)this.enabledBaselineIdentifier()).add("Parameters", this.hasParameters() ? this.parameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "baselineVersion": {
                return Optional.ofNullable(clazz.cast(this.baselineVersion()));
            }
            case "enabledBaselineIdentifier": {
                return Optional.ofNullable(clazz.cast(this.enabledBaselineIdentifier()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("baselineVersion", BASELINE_VERSION_FIELD);
        map.put("enabledBaselineIdentifier", ENABLED_BASELINE_IDENTIFIER_FIELD);
        map.put("parameters", PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateEnabledBaselineRequest, T> g) {
        return obj -> g.apply((UpdateEnabledBaselineRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ControlTowerRequest.BuilderImpl
    implements Builder {
        private String baselineVersion;
        private String enabledBaselineIdentifier;
        private List<EnabledBaselineParameter> parameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEnabledBaselineRequest model) {
            super(model);
            this.baselineVersion(model.baselineVersion);
            this.enabledBaselineIdentifier(model.enabledBaselineIdentifier);
            this.parameters(model.parameters);
        }

        public final String getBaselineVersion() {
            return this.baselineVersion;
        }

        public final void setBaselineVersion(String baselineVersion) {
            this.baselineVersion = baselineVersion;
        }

        @Override
        public final Builder baselineVersion(String baselineVersion) {
            this.baselineVersion = baselineVersion;
            return this;
        }

        public final String getEnabledBaselineIdentifier() {
            return this.enabledBaselineIdentifier;
        }

        public final void setEnabledBaselineIdentifier(String enabledBaselineIdentifier) {
            this.enabledBaselineIdentifier = enabledBaselineIdentifier;
        }

        @Override
        public final Builder enabledBaselineIdentifier(String enabledBaselineIdentifier) {
            this.enabledBaselineIdentifier = enabledBaselineIdentifier;
            return this;
        }

        public final List<EnabledBaselineParameter.Builder> getParameters() {
            List<EnabledBaselineParameter.Builder> result = EnabledBaselineParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<EnabledBaselineParameter.BuilderImpl> parameters) {
            this.parameters = EnabledBaselineParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<EnabledBaselineParameter> parameters) {
            this.parameters = EnabledBaselineParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(EnabledBaselineParameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<EnabledBaselineParameter.Builder> ... parameters) {
            this.parameters(Stream.of(parameters).map(c -> (EnabledBaselineParameter)((EnabledBaselineParameter.Builder)EnabledBaselineParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEnabledBaselineRequest build() {
            return new UpdateEnabledBaselineRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ControlTowerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateEnabledBaselineRequest> {
        public Builder baselineVersion(String var1);

        public Builder enabledBaselineIdentifier(String var1);

        public Builder parameters(Collection<EnabledBaselineParameter> var1);

        public Builder parameters(EnabledBaselineParameter ... var1);

        public Builder parameters(Consumer<EnabledBaselineParameter.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

