/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controlcatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.controlcatalog.model.ControlRelationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RelatedControlMappingDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RelatedControlMappingDetails> {
    private static final SdkField<String> CONTROL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ControlArn").getter(RelatedControlMappingDetails.getter(RelatedControlMappingDetails::controlArn)).setter(RelatedControlMappingDetails.setter(Builder::controlArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlArn").build()}).build();
    private static final SdkField<String> RELATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RelationType").getter(RelatedControlMappingDetails.getter(RelatedControlMappingDetails::relationTypeAsString)).setter(RelatedControlMappingDetails.setter(Builder::relationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelationType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROL_ARN_FIELD, RELATION_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RelatedControlMappingDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String controlArn;
    private final String relationType;

    private RelatedControlMappingDetails(BuilderImpl builder) {
        this.controlArn = builder.controlArn;
        this.relationType = builder.relationType;
    }

    public final String controlArn() {
        return this.controlArn;
    }

    public final ControlRelationType relationType() {
        return ControlRelationType.fromValue(this.relationType);
    }

    public final String relationTypeAsString() {
        return this.relationType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.controlArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.relationTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelatedControlMappingDetails)) {
            return false;
        }
        RelatedControlMappingDetails other = (RelatedControlMappingDetails)obj;
        return Objects.equals(this.controlArn(), other.controlArn()) && Objects.equals(this.relationTypeAsString(), other.relationTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RelatedControlMappingDetails").add("ControlArn", (Object)this.controlArn()).add("RelationType", (Object)this.relationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ControlArn": {
                return Optional.ofNullable(clazz.cast(this.controlArn()));
            }
            case "RelationType": {
                return Optional.ofNullable(clazz.cast(this.relationTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ControlArn", CONTROL_ARN_FIELD);
        map.put("RelationType", RELATION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RelatedControlMappingDetails, T> g) {
        return obj -> g.apply((RelatedControlMappingDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String controlArn;
        private String relationType;

        private BuilderImpl() {
        }

        private BuilderImpl(RelatedControlMappingDetails model) {
            this.controlArn(model.controlArn);
            this.relationType(model.relationType);
        }

        public final String getControlArn() {
            return this.controlArn;
        }

        public final void setControlArn(String controlArn) {
            this.controlArn = controlArn;
        }

        @Override
        public final Builder controlArn(String controlArn) {
            this.controlArn = controlArn;
            return this;
        }

        public final String getRelationType() {
            return this.relationType;
        }

        public final void setRelationType(String relationType) {
            this.relationType = relationType;
        }

        @Override
        public final Builder relationType(String relationType) {
            this.relationType = relationType;
            return this;
        }

        @Override
        public final Builder relationType(ControlRelationType relationType) {
            this.relationType(relationType == null ? null : relationType.toString());
            return this;
        }

        public RelatedControlMappingDetails build() {
            return new RelatedControlMappingDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RelatedControlMappingDetails> {
        public Builder controlArn(String var1);

        public Builder relationType(String var1);

        public Builder relationType(ControlRelationType var1);
    }
}

