/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controlcatalog.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.controlcatalog.ControlCatalogAsyncClient;
import software.amazon.awssdk.services.controlcatalog.internal.UserAgentUtils;
import software.amazon.awssdk.services.controlcatalog.model.ControlSummary;
import software.amazon.awssdk.services.controlcatalog.model.ListControlsRequest;
import software.amazon.awssdk.services.controlcatalog.model.ListControlsResponse;

public class ListControlsPublisher
implements SdkPublisher<ListControlsResponse> {
    private final ControlCatalogAsyncClient client;
    private final ListControlsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListControlsPublisher(ControlCatalogAsyncClient client, ListControlsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListControlsPublisher(ControlCatalogAsyncClient client, ListControlsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListControlsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListControlsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ControlSummary> controls() {
        Function<ListControlsResponse, Iterator> getIterator = response -> {
            if (response != null && response.controls() != null) {
                return response.controls().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListControlsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListControlsResponseFetcher
    implements AsyncPageFetcher<ListControlsResponse> {
        private ListControlsResponseFetcher() {
        }

        public boolean hasNextPage(ListControlsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListControlsResponse> nextPage(ListControlsResponse previousPage) {
            if (previousPage == null) {
                return ListControlsPublisher.this.client.listControls(ListControlsPublisher.this.firstRequest);
            }
            return ListControlsPublisher.this.client.listControls((ListControlsRequest)((Object)ListControlsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

