/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controlcatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.controlcatalog.model.ControlBehavior;
import software.amazon.awssdk.services.controlcatalog.model.ControlCatalogResponse;
import software.amazon.awssdk.services.controlcatalog.model.ControlParameter;
import software.amazon.awssdk.services.controlcatalog.model.ControlParametersCopier;
import software.amazon.awssdk.services.controlcatalog.model.ImplementationDetails;
import software.amazon.awssdk.services.controlcatalog.model.RegionConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetControlResponse
extends ControlCatalogResponse
implements ToCopyableBuilder<Builder, GetControlResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(GetControlResponse.getter(GetControlResponse::arn)).setter(GetControlResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetControlResponse.getter(GetControlResponse::name)).setter(GetControlResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetControlResponse.getter(GetControlResponse::description)).setter(GetControlResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Behavior").getter(GetControlResponse.getter(GetControlResponse::behaviorAsString)).setter(GetControlResponse.setter(Builder::behavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Behavior").build()}).build();
    private static final SdkField<RegionConfiguration> REGION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RegionConfiguration").getter(GetControlResponse.getter(GetControlResponse::regionConfiguration)).setter(GetControlResponse.setter(Builder::regionConfiguration)).constructor(RegionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionConfiguration").build()}).build();
    private static final SdkField<ImplementationDetails> IMPLEMENTATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Implementation").getter(GetControlResponse.getter(GetControlResponse::implementation)).setter(GetControlResponse.setter(Builder::implementation)).constructor(ImplementationDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Implementation").build()}).build();
    private static final SdkField<List<ControlParameter>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Parameters").getter(GetControlResponse.getter(GetControlResponse::parameters)).setter(GetControlResponse.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ControlParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, BEHAVIOR_FIELD, REGION_CONFIGURATION_FIELD, IMPLEMENTATION_FIELD, PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetControlResponse.memberNameToFieldInitializer();
    private final String arn;
    private final String name;
    private final String description;
    private final String behavior;
    private final RegionConfiguration regionConfiguration;
    private final ImplementationDetails implementation;
    private final List<ControlParameter> parameters;

    private GetControlResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.behavior = builder.behavior;
        this.regionConfiguration = builder.regionConfiguration;
        this.implementation = builder.implementation;
        this.parameters = builder.parameters;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final ControlBehavior behavior() {
        return ControlBehavior.fromValue(this.behavior);
    }

    public final String behaviorAsString() {
        return this.behavior;
    }

    public final RegionConfiguration regionConfiguration() {
        return this.regionConfiguration;
    }

    public final ImplementationDetails implementation() {
        return this.implementation;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructList);
    }

    public final List<ControlParameter> parameters() {
        return this.parameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.behaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.implementation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetControlResponse)) {
            return false;
        }
        GetControlResponse other = (GetControlResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.behaviorAsString(), other.behaviorAsString()) && Objects.equals(this.regionConfiguration(), other.regionConfiguration()) && Objects.equals(this.implementation(), other.implementation()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters());
    }

    public final String toString() {
        return ToString.builder((String)"GetControlResponse").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Behavior", (Object)this.behaviorAsString()).add("RegionConfiguration", (Object)this.regionConfiguration()).add("Implementation", (Object)this.implementation()).add("Parameters", this.hasParameters() ? this.parameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Behavior": {
                return Optional.ofNullable(clazz.cast(this.behaviorAsString()));
            }
            case "RegionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.regionConfiguration()));
            }
            case "Implementation": {
                return Optional.ofNullable(clazz.cast(this.implementation()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Behavior", BEHAVIOR_FIELD);
        map.put("RegionConfiguration", REGION_CONFIGURATION_FIELD);
        map.put("Implementation", IMPLEMENTATION_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetControlResponse, T> g) {
        return obj -> g.apply((GetControlResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ControlCatalogResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String description;
        private String behavior;
        private RegionConfiguration regionConfiguration;
        private ImplementationDetails implementation;
        private List<ControlParameter> parameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetControlResponse model) {
            super(model);
            this.arn(model.arn);
            this.name(model.name);
            this.description(model.description);
            this.behavior(model.behavior);
            this.regionConfiguration(model.regionConfiguration);
            this.implementation(model.implementation);
            this.parameters(model.parameters);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getBehavior() {
            return this.behavior;
        }

        public final void setBehavior(String behavior) {
            this.behavior = behavior;
        }

        @Override
        public final Builder behavior(String behavior) {
            this.behavior = behavior;
            return this;
        }

        @Override
        public final Builder behavior(ControlBehavior behavior) {
            this.behavior(behavior == null ? null : behavior.toString());
            return this;
        }

        public final RegionConfiguration.Builder getRegionConfiguration() {
            return this.regionConfiguration != null ? this.regionConfiguration.toBuilder() : null;
        }

        public final void setRegionConfiguration(RegionConfiguration.BuilderImpl regionConfiguration) {
            this.regionConfiguration = regionConfiguration != null ? regionConfiguration.build() : null;
        }

        @Override
        public final Builder regionConfiguration(RegionConfiguration regionConfiguration) {
            this.regionConfiguration = regionConfiguration;
            return this;
        }

        public final ImplementationDetails.Builder getImplementation() {
            return this.implementation != null ? this.implementation.toBuilder() : null;
        }

        public final void setImplementation(ImplementationDetails.BuilderImpl implementation) {
            this.implementation = implementation != null ? implementation.build() : null;
        }

        @Override
        public final Builder implementation(ImplementationDetails implementation) {
            this.implementation = implementation;
            return this;
        }

        public final List<ControlParameter.Builder> getParameters() {
            List<ControlParameter.Builder> result = ControlParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<ControlParameter.BuilderImpl> parameters) {
            this.parameters = ControlParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<ControlParameter> parameters) {
            this.parameters = ControlParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(ControlParameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<ControlParameter.Builder> ... parameters) {
            this.parameters(Stream.of(parameters).map(c -> (ControlParameter)((ControlParameter.Builder)ControlParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetControlResponse build() {
            return new GetControlResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ControlCatalogResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetControlResponse> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder behavior(String var1);

        public Builder behavior(ControlBehavior var1);

        public Builder regionConfiguration(RegionConfiguration var1);

        default public Builder regionConfiguration(Consumer<RegionConfiguration.Builder> regionConfiguration) {
            return this.regionConfiguration((RegionConfiguration)((RegionConfiguration.Builder)RegionConfiguration.builder().applyMutation(regionConfiguration)).build());
        }

        public Builder implementation(ImplementationDetails var1);

        default public Builder implementation(Consumer<ImplementationDetails.Builder> implementation) {
            return this.implementation((ImplementationDetails)((ImplementationDetails.Builder)ImplementationDetails.builder().applyMutation(implementation)).build());
        }

        public Builder parameters(Collection<ControlParameter> var1);

        public Builder parameters(ControlParameter ... var1);

        public Builder parameters(Consumer<ControlParameter.Builder> ... var1);
    }
}

