/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controlcatalog.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.controlcatalog.ControlCatalogClient;
import software.amazon.awssdk.services.controlcatalog.internal.UserAgentUtils;
import software.amazon.awssdk.services.controlcatalog.model.ControlSummary;
import software.amazon.awssdk.services.controlcatalog.model.ListControlsRequest;
import software.amazon.awssdk.services.controlcatalog.model.ListControlsResponse;

public class ListControlsIterable
implements SdkIterable<ListControlsResponse> {
    private final ControlCatalogClient client;
    private final ListControlsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListControlsIterable(ControlCatalogClient client, ListControlsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListControlsResponseFetcher();
    }

    public Iterator<ListControlsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ControlSummary> controls() {
        Function<ListControlsResponse, Iterator> getIterator = response -> {
            if (response != null && response.controls() != null) {
                return response.controls().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListControlsResponseFetcher
    implements SyncPageFetcher<ListControlsResponse> {
        private ListControlsResponseFetcher() {
        }

        public boolean hasNextPage(ListControlsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListControlsResponse nextPage(ListControlsResponse previousPage) {
            if (previousPage == null) {
                return ListControlsIterable.this.client.listControls(ListControlsIterable.this.firstRequest);
            }
            return ListControlsIterable.this.client.listControls((ListControlsRequest)((Object)ListControlsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

