/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connectcases.model.ConnectCasesResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLayoutResponse
extends ConnectCasesResponse
implements ToCopyableBuilder<Builder, CreateLayoutResponse> {
    private static final SdkField<String> LAYOUT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("layoutArn").getter(CreateLayoutResponse.getter(CreateLayoutResponse::layoutArn)).setter(CreateLayoutResponse.setter(Builder::layoutArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layoutArn").build()}).build();
    private static final SdkField<String> LAYOUT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("layoutId").getter(CreateLayoutResponse.getter(CreateLayoutResponse::layoutId)).setter(CreateLayoutResponse.setter(Builder::layoutId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layoutId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAYOUT_ARN_FIELD, LAYOUT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateLayoutResponse.memberNameToFieldInitializer();
    private final String layoutArn;
    private final String layoutId;

    private CreateLayoutResponse(BuilderImpl builder) {
        super(builder);
        this.layoutArn = builder.layoutArn;
        this.layoutId = builder.layoutId;
    }

    public final String layoutArn() {
        return this.layoutArn;
    }

    public final String layoutId() {
        return this.layoutId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.layoutArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.layoutId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLayoutResponse)) {
            return false;
        }
        CreateLayoutResponse other = (CreateLayoutResponse)((Object)obj);
        return Objects.equals(this.layoutArn(), other.layoutArn()) && Objects.equals(this.layoutId(), other.layoutId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateLayoutResponse").add("LayoutArn", (Object)this.layoutArn()).add("LayoutId", (Object)this.layoutId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "layoutArn": {
                return Optional.ofNullable(clazz.cast(this.layoutArn()));
            }
            case "layoutId": {
                return Optional.ofNullable(clazz.cast(this.layoutId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("layoutArn", LAYOUT_ARN_FIELD);
        map.put("layoutId", LAYOUT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateLayoutResponse, T> g) {
        return obj -> g.apply((CreateLayoutResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectCasesResponse.BuilderImpl
    implements Builder {
        private String layoutArn;
        private String layoutId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLayoutResponse model) {
            super(model);
            this.layoutArn(model.layoutArn);
            this.layoutId(model.layoutId);
        }

        public final String getLayoutArn() {
            return this.layoutArn;
        }

        public final void setLayoutArn(String layoutArn) {
            this.layoutArn = layoutArn;
        }

        @Override
        public final Builder layoutArn(String layoutArn) {
            this.layoutArn = layoutArn;
            return this;
        }

        public final String getLayoutId() {
            return this.layoutId;
        }

        public final void setLayoutId(String layoutId) {
            this.layoutId = layoutId;
        }

        @Override
        public final Builder layoutId(String layoutId) {
            this.layoutId = layoutId;
            return this;
        }

        @Override
        public CreateLayoutResponse build() {
            return new CreateLayoutResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectCasesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLayoutResponse> {
        public Builder layoutArn(String var1);

        public Builder layoutId(String var1);
    }
}

