/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContactContent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContactContent> {
    private static final SdkField<String> CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("channel").getter(ContactContent.getter(ContactContent::channel)).setter(ContactContent.setter(Builder::channel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channel").build()}).build();
    private static final SdkField<Instant> CONNECTED_TO_SYSTEM_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("connectedToSystemTime").getter(ContactContent.getter(ContactContent::connectedToSystemTime)).setter(ContactContent.setter(Builder::connectedToSystemTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectedToSystemTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CONTACT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contactArn").getter(ContactContent.getter(ContactContent::contactArn)).setter(ContactContent.setter(Builder::contactArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_FIELD, CONNECTED_TO_SYSTEM_TIME_FIELD, CONTACT_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ContactContent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String channel;
    private final Instant connectedToSystemTime;
    private final String contactArn;

    private ContactContent(BuilderImpl builder) {
        this.channel = builder.channel;
        this.connectedToSystemTime = builder.connectedToSystemTime;
        this.contactArn = builder.contactArn;
    }

    public final String channel() {
        return this.channel;
    }

    public final Instant connectedToSystemTime() {
        return this.connectedToSystemTime;
    }

    public final String contactArn() {
        return this.contactArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.channel());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectedToSystemTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactContent)) {
            return false;
        }
        ContactContent other = (ContactContent)obj;
        return Objects.equals(this.channel(), other.channel()) && Objects.equals(this.connectedToSystemTime(), other.connectedToSystemTime()) && Objects.equals(this.contactArn(), other.contactArn());
    }

    public final String toString() {
        return ToString.builder((String)"ContactContent").add("Channel", (Object)this.channel()).add("ConnectedToSystemTime", (Object)this.connectedToSystemTime()).add("ContactArn", (Object)this.contactArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "channel": {
                return Optional.ofNullable(clazz.cast(this.channel()));
            }
            case "connectedToSystemTime": {
                return Optional.ofNullable(clazz.cast(this.connectedToSystemTime()));
            }
            case "contactArn": {
                return Optional.ofNullable(clazz.cast(this.contactArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channel", CHANNEL_FIELD);
        map.put("connectedToSystemTime", CONNECTED_TO_SYSTEM_TIME_FIELD);
        map.put("contactArn", CONTACT_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContactContent, T> g) {
        return obj -> g.apply((ContactContent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String channel;
        private Instant connectedToSystemTime;
        private String contactArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ContactContent model) {
            this.channel(model.channel);
            this.connectedToSystemTime(model.connectedToSystemTime);
            this.contactArn(model.contactArn);
        }

        public final String getChannel() {
            return this.channel;
        }

        public final void setChannel(String channel) {
            this.channel = channel;
        }

        @Override
        public final Builder channel(String channel) {
            this.channel = channel;
            return this;
        }

        public final Instant getConnectedToSystemTime() {
            return this.connectedToSystemTime;
        }

        public final void setConnectedToSystemTime(Instant connectedToSystemTime) {
            this.connectedToSystemTime = connectedToSystemTime;
        }

        @Override
        public final Builder connectedToSystemTime(Instant connectedToSystemTime) {
            this.connectedToSystemTime = connectedToSystemTime;
            return this;
        }

        public final String getContactArn() {
            return this.contactArn;
        }

        public final void setContactArn(String contactArn) {
            this.contactArn = contactArn;
        }

        @Override
        public final Builder contactArn(String contactArn) {
            this.contactArn = contactArn;
            return this;
        }

        public ContactContent build() {
            return new ContactContent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContactContent> {
        public Builder channel(String var1);

        public Builder connectedToSystemTime(Instant var1);

        public Builder contactArn(String var1);
    }
}

