/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connectcases.ConnectCasesClient;
import software.amazon.awssdk.services.connectcases.internal.UserAgentUtils;
import software.amazon.awssdk.services.connectcases.model.CaseRuleSummary;
import software.amazon.awssdk.services.connectcases.model.ListCaseRulesRequest;
import software.amazon.awssdk.services.connectcases.model.ListCaseRulesResponse;

public class ListCaseRulesIterable
implements SdkIterable<ListCaseRulesResponse> {
    private final ConnectCasesClient client;
    private final ListCaseRulesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCaseRulesIterable(ConnectCasesClient client, ListCaseRulesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCaseRulesResponseFetcher();
    }

    public Iterator<ListCaseRulesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CaseRuleSummary> caseRules() {
        Function<ListCaseRulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.caseRules() != null) {
                return response.caseRules().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCaseRulesResponseFetcher
    implements SyncPageFetcher<ListCaseRulesResponse> {
        private ListCaseRulesResponseFetcher() {
        }

        public boolean hasNextPage(ListCaseRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCaseRulesResponse nextPage(ListCaseRulesResponse previousPage) {
            if (previousPage == null) {
                return ListCaseRulesIterable.this.client.listCaseRules(ListCaseRulesIterable.this.firstRequest);
            }
            return ListCaseRulesIterable.this.client.listCaseRules((ListCaseRulesRequest)((Object)ListCaseRulesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

