/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connectcases.model.CaseRuleIdentifier;
import software.amazon.awssdk.services.connectcases.model.CaseRuleIdentifierListCopier;
import software.amazon.awssdk.services.connectcases.model.ConnectCasesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetCaseRuleRequest
extends ConnectCasesRequest
implements ToCopyableBuilder<Builder, BatchGetCaseRuleRequest> {
    private static final SdkField<List<CaseRuleIdentifier>> CASE_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("caseRules").getter(BatchGetCaseRuleRequest.getter(BatchGetCaseRuleRequest::caseRules)).setter(BatchGetCaseRuleRequest.setter(Builder::caseRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caseRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CaseRuleIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainId").getter(BatchGetCaseRuleRequest.getter(BatchGetCaseRuleRequest::domainId)).setter(BatchGetCaseRuleRequest.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CASE_RULES_FIELD, DOMAIN_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetCaseRuleRequest.memberNameToFieldInitializer();
    private final List<CaseRuleIdentifier> caseRules;
    private final String domainId;

    private BatchGetCaseRuleRequest(BuilderImpl builder) {
        super(builder);
        this.caseRules = builder.caseRules;
        this.domainId = builder.domainId;
    }

    public final boolean hasCaseRules() {
        return this.caseRules != null && !(this.caseRules instanceof SdkAutoConstructList);
    }

    public final List<CaseRuleIdentifier> caseRules() {
        return this.caseRules;
    }

    public final String domainId() {
        return this.domainId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCaseRules() ? this.caseRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetCaseRuleRequest)) {
            return false;
        }
        BatchGetCaseRuleRequest other = (BatchGetCaseRuleRequest)((Object)obj);
        return this.hasCaseRules() == other.hasCaseRules() && Objects.equals(this.caseRules(), other.caseRules()) && Objects.equals(this.domainId(), other.domainId());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetCaseRuleRequest").add("CaseRules", this.hasCaseRules() ? this.caseRules() : null).add("DomainId", (Object)this.domainId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "caseRules": {
                return Optional.ofNullable(clazz.cast(this.caseRules()));
            }
            case "domainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("caseRules", CASE_RULES_FIELD);
        map.put("domainId", DOMAIN_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetCaseRuleRequest, T> g) {
        return obj -> g.apply((BatchGetCaseRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectCasesRequest.BuilderImpl
    implements Builder {
        private List<CaseRuleIdentifier> caseRules = DefaultSdkAutoConstructList.getInstance();
        private String domainId;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetCaseRuleRequest model) {
            super(model);
            this.caseRules(model.caseRules);
            this.domainId(model.domainId);
        }

        public final List<CaseRuleIdentifier.Builder> getCaseRules() {
            List<CaseRuleIdentifier.Builder> result = CaseRuleIdentifierListCopier.copyToBuilder(this.caseRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCaseRules(Collection<CaseRuleIdentifier.BuilderImpl> caseRules) {
            this.caseRules = CaseRuleIdentifierListCopier.copyFromBuilder(caseRules);
        }

        @Override
        public final Builder caseRules(Collection<CaseRuleIdentifier> caseRules) {
            this.caseRules = CaseRuleIdentifierListCopier.copy(caseRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder caseRules(CaseRuleIdentifier ... caseRules) {
            this.caseRules(Arrays.asList(caseRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder caseRules(Consumer<CaseRuleIdentifier.Builder> ... caseRules) {
            this.caseRules(Stream.of(caseRules).map(c -> (CaseRuleIdentifier)((CaseRuleIdentifier.Builder)CaseRuleIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetCaseRuleRequest build() {
            return new BatchGetCaseRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectCasesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetCaseRuleRequest> {
        public Builder caseRules(Collection<CaseRuleIdentifier> var1);

        public Builder caseRules(CaseRuleIdentifier ... var1);

        public Builder caseRules(Consumer<CaseRuleIdentifier.Builder> ... var1);

        public Builder domainId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

