/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connectcases.model.BooleanCondition;
import software.amazon.awssdk.services.connectcases.model.BooleanConditionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RequiredCaseRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RequiredCaseRule> {
    private static final SdkField<List<BooleanCondition>> CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("conditions").getter(RequiredCaseRule.getter(RequiredCaseRule::conditions)).setter(RequiredCaseRule.setter(Builder::conditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BooleanCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DEFAULT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("defaultValue").getter(RequiredCaseRule.getter(RequiredCaseRule::defaultValue)).setter(RequiredCaseRule.setter(Builder::defaultValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONDITIONS_FIELD, DEFAULT_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RequiredCaseRule.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<BooleanCondition> conditions;
    private final Boolean defaultValue;

    private RequiredCaseRule(BuilderImpl builder) {
        this.conditions = builder.conditions;
        this.defaultValue = builder.defaultValue;
    }

    public final boolean hasConditions() {
        return this.conditions != null && !(this.conditions instanceof SdkAutoConstructList);
    }

    public final List<BooleanCondition> conditions() {
        return this.conditions;
    }

    public final Boolean defaultValue() {
        return this.defaultValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConditions() ? this.conditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequiredCaseRule)) {
            return false;
        }
        RequiredCaseRule other = (RequiredCaseRule)obj;
        return this.hasConditions() == other.hasConditions() && Objects.equals(this.conditions(), other.conditions()) && Objects.equals(this.defaultValue(), other.defaultValue());
    }

    public final String toString() {
        return ToString.builder((String)"RequiredCaseRule").add("Conditions", this.hasConditions() ? this.conditions() : null).add("DefaultValue", (Object)this.defaultValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "conditions": {
                return Optional.ofNullable(clazz.cast(this.conditions()));
            }
            case "defaultValue": {
                return Optional.ofNullable(clazz.cast(this.defaultValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("conditions", CONDITIONS_FIELD);
        map.put("defaultValue", DEFAULT_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RequiredCaseRule, T> g) {
        return obj -> g.apply((RequiredCaseRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<BooleanCondition> conditions = DefaultSdkAutoConstructList.getInstance();
        private Boolean defaultValue;

        private BuilderImpl() {
        }

        private BuilderImpl(RequiredCaseRule model) {
            this.conditions(model.conditions);
            this.defaultValue(model.defaultValue);
        }

        public final List<BooleanCondition.Builder> getConditions() {
            List<BooleanCondition.Builder> result = BooleanConditionListCopier.copyToBuilder(this.conditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConditions(Collection<BooleanCondition.BuilderImpl> conditions) {
            this.conditions = BooleanConditionListCopier.copyFromBuilder(conditions);
        }

        @Override
        public final Builder conditions(Collection<BooleanCondition> conditions) {
            this.conditions = BooleanConditionListCopier.copy(conditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(BooleanCondition ... conditions) {
            this.conditions(Arrays.asList(conditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(Consumer<BooleanCondition.Builder> ... conditions) {
            this.conditions(Stream.of(conditions).map(c -> (BooleanCondition)((BooleanCondition.Builder)BooleanCondition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getDefaultValue() {
            return this.defaultValue;
        }

        public final void setDefaultValue(Boolean defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(Boolean defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public RequiredCaseRule build() {
            return new RequiredCaseRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RequiredCaseRule> {
        public Builder conditions(Collection<BooleanCondition> var1);

        public Builder conditions(BooleanCondition ... var1);

        public Builder conditions(Consumer<BooleanCondition.Builder> ... var1);

        public Builder defaultValue(Boolean var1);
    }
}

