/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connectcases.ConnectCasesClient;
import software.amazon.awssdk.services.connectcases.internal.UserAgentUtils;
import software.amazon.awssdk.services.connectcases.model.ListFieldsRequest;
import software.amazon.awssdk.services.connectcases.model.ListFieldsResponse;

public class ListFieldsIterable
implements SdkIterable<ListFieldsResponse> {
    private final ConnectCasesClient client;
    private final ListFieldsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFieldsIterable(ConnectCasesClient client, ListFieldsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListFieldsResponseFetcher();
    }

    public Iterator<ListFieldsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListFieldsResponseFetcher
    implements SyncPageFetcher<ListFieldsResponse> {
        private ListFieldsResponseFetcher() {
        }

        public boolean hasNextPage(ListFieldsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFieldsResponse nextPage(ListFieldsResponse previousPage) {
            if (previousPage == null) {
                return ListFieldsIterable.this.client.listFields(ListFieldsIterable.this.firstRequest);
            }
            return ListFieldsIterable.this.client.listFields((ListFieldsRequest)((Object)ListFieldsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

