/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connectcases.ConnectCasesAsyncClient;
import software.amazon.awssdk.services.connectcases.internal.UserAgentUtils;
import software.amazon.awssdk.services.connectcases.model.GetCaseAuditEventsRequest;
import software.amazon.awssdk.services.connectcases.model.GetCaseAuditEventsResponse;

public class GetCaseAuditEventsPublisher
implements SdkPublisher<GetCaseAuditEventsResponse> {
    private final ConnectCasesAsyncClient client;
    private final GetCaseAuditEventsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetCaseAuditEventsPublisher(ConnectCasesAsyncClient client, GetCaseAuditEventsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetCaseAuditEventsPublisher(ConnectCasesAsyncClient client, GetCaseAuditEventsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetCaseAuditEventsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetCaseAuditEventsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetCaseAuditEventsResponseFetcher
    implements AsyncPageFetcher<GetCaseAuditEventsResponse> {
        private GetCaseAuditEventsResponseFetcher() {
        }

        public boolean hasNextPage(GetCaseAuditEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetCaseAuditEventsResponse> nextPage(GetCaseAuditEventsResponse previousPage) {
            if (previousPage == null) {
                return GetCaseAuditEventsPublisher.this.client.getCaseAuditEvents(GetCaseAuditEventsPublisher.this.firstRequest);
            }
            return GetCaseAuditEventsPublisher.this.client.getCaseAuditEvents((GetCaseAuditEventsRequest)((Object)GetCaseAuditEventsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

