/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connectcases.model.CommentFilter;
import software.amazon.awssdk.services.connectcases.model.ContactFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RelatedItemTypeFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RelatedItemTypeFilter> {
    private static final SdkField<CommentFilter> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("comment").getter(RelatedItemTypeFilter.getter(RelatedItemTypeFilter::comment)).setter(RelatedItemTypeFilter.setter(Builder::comment)).constructor(CommentFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()}).build();
    private static final SdkField<ContactFilter> CONTACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("contact").getter(RelatedItemTypeFilter.getter(RelatedItemTypeFilter::contact)).setter(RelatedItemTypeFilter.setter(Builder::contact)).constructor(ContactFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contact").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMENT_FIELD, CONTACT_FIELD));
    private static final long serialVersionUID = 1L;
    private final CommentFilter comment;
    private final ContactFilter contact;
    private final Type type;

    private RelatedItemTypeFilter(BuilderImpl builder) {
        this.comment = builder.comment;
        this.contact = builder.contact;
        this.type = builder.type;
    }

    public final CommentFilter comment() {
        return this.comment;
    }

    public final ContactFilter contact() {
        return this.contact;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.contact());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelatedItemTypeFilter)) {
            return false;
        }
        RelatedItemTypeFilter other = (RelatedItemTypeFilter)obj;
        return Objects.equals(this.comment(), other.comment()) && Objects.equals(this.contact(), other.contact());
    }

    public final String toString() {
        return ToString.builder((String)"RelatedItemTypeFilter").add("Comment", (Object)this.comment()).add("Contact", (Object)this.contact()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
            case "contact": {
                return Optional.ofNullable(clazz.cast(this.contact()));
            }
        }
        return Optional.empty();
    }

    public static RelatedItemTypeFilter fromComment(CommentFilter comment) {
        return (RelatedItemTypeFilter)RelatedItemTypeFilter.builder().comment(comment).build();
    }

    public static RelatedItemTypeFilter fromComment(Consumer<CommentFilter.Builder> comment) {
        CommentFilter.Builder builder = CommentFilter.builder();
        comment.accept(builder);
        return RelatedItemTypeFilter.fromComment((CommentFilter)builder.build());
    }

    public static RelatedItemTypeFilter fromContact(ContactFilter contact) {
        return (RelatedItemTypeFilter)RelatedItemTypeFilter.builder().contact(contact).build();
    }

    public static RelatedItemTypeFilter fromContact(Consumer<ContactFilter.Builder> contact) {
        ContactFilter.Builder builder = ContactFilter.builder();
        contact.accept(builder);
        return RelatedItemTypeFilter.fromContact((ContactFilter)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RelatedItemTypeFilter, T> g) {
        return obj -> g.apply((RelatedItemTypeFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        COMMENT,
        CONTACT,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private CommentFilter comment;
        private ContactFilter contact;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RelatedItemTypeFilter model) {
            this.comment(model.comment);
            this.contact(model.contact);
        }

        public final CommentFilter.Builder getComment() {
            return this.comment != null ? this.comment.toBuilder() : null;
        }

        public final void setComment(CommentFilter.BuilderImpl comment) {
            CommentFilter oldValue = this.comment;
            this.comment = comment != null ? comment.build() : null;
            this.handleUnionValueChange(Type.COMMENT, oldValue, this.comment);
        }

        @Override
        public final Builder comment(CommentFilter comment) {
            CommentFilter oldValue = this.comment;
            this.comment = comment;
            this.handleUnionValueChange(Type.COMMENT, oldValue, this.comment);
            return this;
        }

        public final ContactFilter.Builder getContact() {
            return this.contact != null ? this.contact.toBuilder() : null;
        }

        public final void setContact(ContactFilter.BuilderImpl contact) {
            ContactFilter oldValue = this.contact;
            this.contact = contact != null ? contact.build() : null;
            this.handleUnionValueChange(Type.CONTACT, oldValue, this.contact);
        }

        @Override
        public final Builder contact(ContactFilter contact) {
            ContactFilter oldValue = this.contact;
            this.contact = contact;
            this.handleUnionValueChange(Type.CONTACT, oldValue, this.contact);
            return this;
        }

        public RelatedItemTypeFilter build() {
            return new RelatedItemTypeFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RelatedItemTypeFilter> {
        public Builder comment(CommentFilter var1);

        default public Builder comment(Consumer<CommentFilter.Builder> comment) {
            return this.comment((CommentFilter)((CommentFilter.Builder)CommentFilter.builder().applyMutation(comment)).build());
        }

        public Builder contact(ContactFilter var1);

        default public Builder contact(Consumer<ContactFilter.Builder> contact) {
            return this.contact((ContactFilter)((ContactFilter.Builder)ContactFilter.builder().applyMutation(contact)).build());
        }
    }
}

