/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connectcases.ConnectCasesClient;
import software.amazon.awssdk.services.connectcases.model.ListCasesForContactRequest;
import software.amazon.awssdk.services.connectcases.model.ListCasesForContactResponse;

public class ListCasesForContactIterable
implements SdkIterable<ListCasesForContactResponse> {
    private final ConnectCasesClient client;
    private final ListCasesForContactRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCasesForContactIterable(ConnectCasesClient client, ListCasesForContactRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListCasesForContactResponseFetcher();
    }

    public Iterator<ListCasesForContactResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListCasesForContactResponseFetcher
    implements SyncPageFetcher<ListCasesForContactResponse> {
        private ListCasesForContactResponseFetcher() {
        }

        public boolean hasNextPage(ListCasesForContactResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCasesForContactResponse nextPage(ListCasesForContactResponse previousPage) {
            if (previousPage == null) {
                return ListCasesForContactIterable.this.client.listCasesForContact(ListCasesForContactIterable.this.firstRequest);
            }
            return ListCasesForContactIterable.this.client.listCasesForContact((ListCasesForContactRequest)((Object)ListCasesForContactIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

