/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connectcases.ConnectCasesAsyncClient;
import software.amazon.awssdk.services.connectcases.model.SearchCasesRequest;
import software.amazon.awssdk.services.connectcases.model.SearchCasesResponse;
import software.amazon.awssdk.services.connectcases.model.SearchCasesResponseItem;

public class SearchCasesPublisher
implements SdkPublisher<SearchCasesResponse> {
    private final ConnectCasesAsyncClient client;
    private final SearchCasesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchCasesPublisher(ConnectCasesAsyncClient client, SearchCasesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchCasesPublisher(ConnectCasesAsyncClient client, SearchCasesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchCasesResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchCasesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SearchCasesResponseItem> cases() {
        Function<SearchCasesResponse, Iterator> getIterator = response -> {
            if (response != null && response.cases() != null) {
                return response.cases().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchCasesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchCasesResponseFetcher
    implements AsyncPageFetcher<SearchCasesResponse> {
        private SearchCasesResponseFetcher() {
        }

        public boolean hasNextPage(SearchCasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchCasesResponse> nextPage(SearchCasesResponse previousPage) {
            if (previousPage == null) {
                return SearchCasesPublisher.this.client.searchCases(SearchCasesPublisher.this.firstRequest);
            }
            return SearchCasesPublisher.this.client.searchCases((SearchCasesRequest)((Object)SearchCasesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

