/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connectcases.model.BatchGetFieldResponseErrorsListCopier;
import software.amazon.awssdk.services.connectcases.model.BatchGetFieldResponseFieldsListCopier;
import software.amazon.awssdk.services.connectcases.model.ConnectCasesResponse;
import software.amazon.awssdk.services.connectcases.model.FieldError;
import software.amazon.awssdk.services.connectcases.model.GetFieldResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetFieldResponse
extends ConnectCasesResponse
implements ToCopyableBuilder<Builder, BatchGetFieldResponse> {
    private static final SdkField<List<FieldError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errors").getter(BatchGetFieldResponse.getter(BatchGetFieldResponse::errors)).setter(BatchGetFieldResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FieldError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<GetFieldResponse>> FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("fields").getter(BatchGetFieldResponse.getter(BatchGetFieldResponse::fields)).setter(BatchGetFieldResponse.setter(Builder::fields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GetFieldResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERRORS_FIELD, FIELDS_FIELD));
    private final List<FieldError> errors;
    private final List<GetFieldResponse> fields;

    private BatchGetFieldResponse(BuilderImpl builder) {
        super(builder);
        this.errors = builder.errors;
        this.fields = builder.fields;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<FieldError> errors() {
        return this.errors;
    }

    public final boolean hasFields() {
        return this.fields != null && !(this.fields instanceof SdkAutoConstructList);
    }

    public final List<GetFieldResponse> fields() {
        return this.fields;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFields() ? this.fields() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetFieldResponse)) {
            return false;
        }
        BatchGetFieldResponse other = (BatchGetFieldResponse)((Object)obj);
        return this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors()) && this.hasFields() == other.hasFields() && Objects.equals(this.fields(), other.fields());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetFieldResponse").add("Errors", this.hasErrors() ? this.errors() : null).add("Fields", this.hasFields() ? this.fields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
            case "fields": {
                return Optional.ofNullable(clazz.cast(this.fields()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetFieldResponse, T> g) {
        return obj -> g.apply((BatchGetFieldResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectCasesResponse.BuilderImpl
    implements Builder {
        private List<FieldError> errors = DefaultSdkAutoConstructList.getInstance();
        private List<GetFieldResponse> fields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetFieldResponse model) {
            super(model);
            this.errors(model.errors);
            this.fields(model.fields);
        }

        public final List<FieldError.Builder> getErrors() {
            List<FieldError.Builder> result = BatchGetFieldResponseErrorsListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<FieldError.BuilderImpl> errors) {
            this.errors = BatchGetFieldResponseErrorsListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<FieldError> errors) {
            this.errors = BatchGetFieldResponseErrorsListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(FieldError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<FieldError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (FieldError)((FieldError.Builder)FieldError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<GetFieldResponse.Builder> getFields() {
            List<GetFieldResponse.Builder> result = BatchGetFieldResponseFieldsListCopier.copyToBuilder(this.fields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFields(Collection<GetFieldResponse.BuilderImpl> fields) {
            this.fields = BatchGetFieldResponseFieldsListCopier.copyFromBuilder(fields);
        }

        @Override
        public final Builder fields(Collection<GetFieldResponse> fields) {
            this.fields = BatchGetFieldResponseFieldsListCopier.copy(fields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(GetFieldResponse ... fields) {
            this.fields(Arrays.asList(fields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(Consumer<GetFieldResponse.Builder> ... fields) {
            this.fields(Stream.of(fields).map(c -> (GetFieldResponse)((GetFieldResponse.Builder)GetFieldResponse.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetFieldResponse build() {
            return new BatchGetFieldResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectCasesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetFieldResponse> {
        public Builder errors(Collection<FieldError> var1);

        public Builder errors(FieldError ... var1);

        public Builder errors(Consumer<FieldError.Builder> ... var1);

        public Builder fields(Collection<GetFieldResponse> var1);

        public Builder fields(GetFieldResponse ... var1);

        public Builder fields(Consumer<GetFieldResponse.Builder> ... var1);
    }
}

