/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connectcases.model.ConnectCasesResponse;
import software.amazon.awssdk.services.connectcases.model.LayoutContent;
import software.amazon.awssdk.services.connectcases.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLayoutResponse
extends ConnectCasesResponse
implements ToCopyableBuilder<Builder, GetLayoutResponse> {
    private static final SdkField<LayoutContent> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("content").getter(GetLayoutResponse.getter(GetLayoutResponse::content)).setter(GetLayoutResponse.setter(Builder::content)).constructor(LayoutContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()}).build();
    private static final SdkField<String> LAYOUT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("layoutArn").getter(GetLayoutResponse.getter(GetLayoutResponse::layoutArn)).setter(GetLayoutResponse.setter(Builder::layoutArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layoutArn").build()}).build();
    private static final SdkField<String> LAYOUT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("layoutId").getter(GetLayoutResponse.getter(GetLayoutResponse::layoutId)).setter(GetLayoutResponse.setter(Builder::layoutId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layoutId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetLayoutResponse.getter(GetLayoutResponse::name)).setter(GetLayoutResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetLayoutResponse.getter(GetLayoutResponse::tags)).setter(GetLayoutResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD, LAYOUT_ARN_FIELD, LAYOUT_ID_FIELD, NAME_FIELD, TAGS_FIELD));
    private final LayoutContent content;
    private final String layoutArn;
    private final String layoutId;
    private final String name;
    private final Map<String, String> tags;

    private GetLayoutResponse(BuilderImpl builder) {
        super(builder);
        this.content = builder.content;
        this.layoutArn = builder.layoutArn;
        this.layoutId = builder.layoutId;
        this.name = builder.name;
        this.tags = builder.tags;
    }

    public final LayoutContent content() {
        return this.content;
    }

    public final String layoutArn() {
        return this.layoutArn;
    }

    public final String layoutId() {
        return this.layoutId;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.layoutArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.layoutId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLayoutResponse)) {
            return false;
        }
        GetLayoutResponse other = (GetLayoutResponse)((Object)obj);
        return Objects.equals(this.content(), other.content()) && Objects.equals(this.layoutArn(), other.layoutArn()) && Objects.equals(this.layoutId(), other.layoutId()) && Objects.equals(this.name(), other.name()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetLayoutResponse").add("Content", (Object)this.content()).add("LayoutArn", (Object)this.layoutArn()).add("LayoutId", (Object)this.layoutId()).add("Name", (Object)this.name()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "layoutArn": {
                return Optional.ofNullable(clazz.cast(this.layoutArn()));
            }
            case "layoutId": {
                return Optional.ofNullable(clazz.cast(this.layoutId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLayoutResponse, T> g) {
        return obj -> g.apply((GetLayoutResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectCasesResponse.BuilderImpl
    implements Builder {
        private LayoutContent content;
        private String layoutArn;
        private String layoutId;
        private String name;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetLayoutResponse model) {
            super(model);
            this.content(model.content);
            this.layoutArn(model.layoutArn);
            this.layoutId(model.layoutId);
            this.name(model.name);
            this.tags(model.tags);
        }

        public final LayoutContent.Builder getContent() {
            return this.content != null ? this.content.toBuilder() : null;
        }

        public final void setContent(LayoutContent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(LayoutContent content) {
            this.content = content;
            return this;
        }

        public final String getLayoutArn() {
            return this.layoutArn;
        }

        public final void setLayoutArn(String layoutArn) {
            this.layoutArn = layoutArn;
        }

        @Override
        public final Builder layoutArn(String layoutArn) {
            this.layoutArn = layoutArn;
            return this;
        }

        public final String getLayoutId() {
            return this.layoutId;
        }

        public final void setLayoutId(String layoutId) {
            this.layoutId = layoutId;
        }

        @Override
        public final Builder layoutId(String layoutId) {
            this.layoutId = layoutId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public GetLayoutResponse build() {
            return new GetLayoutResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectCasesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetLayoutResponse> {
        public Builder content(LayoutContent var1);

        default public Builder content(Consumer<LayoutContent.Builder> content) {
            return this.content((LayoutContent)((LayoutContent.Builder)LayoutContent.builder().applyMutation(content)).build());
        }

        public Builder layoutArn(String var1);

        public Builder layoutId(String var1);

        public Builder name(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

