/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connectcases.ConnectCasesAsyncClient;
import software.amazon.awssdk.services.connectcases.model.GetCaseRequest;
import software.amazon.awssdk.services.connectcases.model.GetCaseResponse;

public class GetCasePublisher
implements SdkPublisher<GetCaseResponse> {
    private final ConnectCasesAsyncClient client;
    private final GetCaseRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetCasePublisher(ConnectCasesAsyncClient client, GetCaseRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetCasePublisher(ConnectCasesAsyncClient client, GetCaseRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetCaseResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetCaseResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetCaseResponseFetcher
    implements AsyncPageFetcher<GetCaseResponse> {
        private GetCaseResponseFetcher() {
        }

        public boolean hasNextPage(GetCaseResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetCaseResponse> nextPage(GetCaseResponse previousPage) {
            if (previousPage == null) {
                return GetCasePublisher.this.client.getCase(GetCasePublisher.this.firstRequest);
            }
            return GetCasePublisher.this.client.getCase((GetCaseRequest)((Object)GetCasePublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

