/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FieldValueUnion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FieldValueUnion> {
    private static final SdkField<Boolean> BOOLEAN_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("booleanValue").getter(FieldValueUnion.getter(FieldValueUnion::booleanValue)).setter(FieldValueUnion.setter(Builder::booleanValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("booleanValue").build()}).build();
    private static final SdkField<Double> DOUBLE_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("doubleValue").getter(FieldValueUnion.getter(FieldValueUnion::doubleValue)).setter(FieldValueUnion.setter(Builder::doubleValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("doubleValue").build()}).build();
    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stringValue").getter(FieldValueUnion.getter(FieldValueUnion::stringValue)).setter(FieldValueUnion.setter(Builder::stringValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOOLEAN_VALUE_FIELD, DOUBLE_VALUE_FIELD, STRING_VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean booleanValue;
    private final Double doubleValue;
    private final String stringValue;
    private final Type type;

    private FieldValueUnion(BuilderImpl builder) {
        this.booleanValue = builder.booleanValue;
        this.doubleValue = builder.doubleValue;
        this.stringValue = builder.stringValue;
        this.type = builder.type;
    }

    public final Boolean booleanValue() {
        return this.booleanValue;
    }

    public final Double doubleValue() {
        return this.doubleValue;
    }

    public final String stringValue() {
        return this.stringValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.booleanValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.doubleValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.stringValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldValueUnion)) {
            return false;
        }
        FieldValueUnion other = (FieldValueUnion)obj;
        return Objects.equals(this.booleanValue(), other.booleanValue()) && Objects.equals(this.doubleValue(), other.doubleValue()) && Objects.equals(this.stringValue(), other.stringValue());
    }

    public final String toString() {
        return ToString.builder((String)"FieldValueUnion").add("BooleanValue", (Object)this.booleanValue()).add("DoubleValue", (Object)this.doubleValue()).add("StringValue", (Object)this.stringValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "booleanValue": {
                return Optional.ofNullable(clazz.cast(this.booleanValue()));
            }
            case "doubleValue": {
                return Optional.ofNullable(clazz.cast(this.doubleValue()));
            }
            case "stringValue": {
                return Optional.ofNullable(clazz.cast(this.stringValue()));
            }
        }
        return Optional.empty();
    }

    public static FieldValueUnion fromBooleanValue(Boolean booleanValue) {
        return (FieldValueUnion)FieldValueUnion.builder().booleanValue(booleanValue).build();
    }

    public static FieldValueUnion fromDoubleValue(Double doubleValue) {
        return (FieldValueUnion)FieldValueUnion.builder().doubleValue(doubleValue).build();
    }

    public static FieldValueUnion fromStringValue(String stringValue) {
        return (FieldValueUnion)FieldValueUnion.builder().stringValue(stringValue).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FieldValueUnion, T> g) {
        return obj -> g.apply((FieldValueUnion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        BOOLEAN_VALUE,
        DOUBLE_VALUE,
        STRING_VALUE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private Boolean booleanValue;
        private Double doubleValue;
        private String stringValue;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(FieldValueUnion model) {
            this.booleanValue(model.booleanValue);
            this.doubleValue(model.doubleValue);
            this.stringValue(model.stringValue);
        }

        public final Boolean getBooleanValue() {
            return this.booleanValue;
        }

        public final void setBooleanValue(Boolean booleanValue) {
            Boolean oldValue = this.booleanValue;
            this.booleanValue = booleanValue;
            this.handleUnionValueChange(Type.BOOLEAN_VALUE, oldValue, this.booleanValue);
        }

        @Override
        public final Builder booleanValue(Boolean booleanValue) {
            Boolean oldValue = this.booleanValue;
            this.booleanValue = booleanValue;
            this.handleUnionValueChange(Type.BOOLEAN_VALUE, oldValue, this.booleanValue);
            return this;
        }

        public final Double getDoubleValue() {
            return this.doubleValue;
        }

        public final void setDoubleValue(Double doubleValue) {
            Double oldValue = this.doubleValue;
            this.doubleValue = doubleValue;
            this.handleUnionValueChange(Type.DOUBLE_VALUE, oldValue, this.doubleValue);
        }

        @Override
        public final Builder doubleValue(Double doubleValue) {
            Double oldValue = this.doubleValue;
            this.doubleValue = doubleValue;
            this.handleUnionValueChange(Type.DOUBLE_VALUE, oldValue, this.doubleValue);
            return this;
        }

        public final String getStringValue() {
            return this.stringValue;
        }

        public final void setStringValue(String stringValue) {
            String oldValue = this.stringValue;
            this.stringValue = stringValue;
            this.handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
        }

        @Override
        public final Builder stringValue(String stringValue) {
            String oldValue = this.stringValue;
            this.stringValue = stringValue;
            this.handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
            return this;
        }

        public FieldValueUnion build() {
            return new FieldValueUnion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FieldValueUnion> {
        public Builder booleanValue(Boolean var1);

        public Builder doubleValue(Double var1);

        public Builder stringValue(String var1);
    }
}

