/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.CurrentMetric;
import software.amazon.awssdk.services.connect.model.CurrentMetricsCopier;
import software.amazon.awssdk.services.connect.model.Filters;
import software.amazon.awssdk.services.connect.model.Grouping;
import software.amazon.awssdk.services.connect.model.GroupingsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCurrentMetricDataRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, GetCurrentMetricDataRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetCurrentMetricDataRequest.getter(GetCurrentMetricDataRequest::instanceId)).setter(GetCurrentMetricDataRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<Filters> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetCurrentMetricDataRequest.getter(GetCurrentMetricDataRequest::filters)).setter(GetCurrentMetricDataRequest.setter(Builder::filters)).constructor(Filters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()}).build();
    private static final SdkField<List<String>> GROUPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetCurrentMetricDataRequest.getter(GetCurrentMetricDataRequest::groupingsAsStrings)).setter(GetCurrentMetricDataRequest.setter(Builder::groupingsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Groupings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CurrentMetric>> CURRENT_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetCurrentMetricDataRequest.getter(GetCurrentMetricDataRequest::currentMetrics)).setter(GetCurrentMetricDataRequest.setter(Builder::currentMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentMetrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CurrentMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetCurrentMetricDataRequest.getter(GetCurrentMetricDataRequest::nextToken)).setter(GetCurrentMetricDataRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(GetCurrentMetricDataRequest.getter(GetCurrentMetricDataRequest::maxResults)).setter(GetCurrentMetricDataRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, FILTERS_FIELD, GROUPINGS_FIELD, CURRENT_METRICS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final String instanceId;
    private final Filters filters;
    private final List<String> groupings;
    private final List<CurrentMetric> currentMetrics;
    private final String nextToken;
    private final Integer maxResults;

    private GetCurrentMetricDataRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.filters = builder.filters;
        this.groupings = builder.groupings;
        this.currentMetrics = builder.currentMetrics;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public Filters filters() {
        return this.filters;
    }

    public List<Grouping> groupings() {
        return GroupingsCopier.copyStringToEnum(this.groupings);
    }

    public List<String> groupingsAsStrings() {
        return this.groupings;
    }

    public List<CurrentMetric> currentMetrics() {
        return this.currentMetrics;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupingsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCurrentMetricDataRequest)) {
            return false;
        }
        GetCurrentMetricDataRequest other = (GetCurrentMetricDataRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.groupingsAsStrings(), other.groupingsAsStrings()) && Objects.equals(this.currentMetrics(), other.currentMetrics()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        return ToString.builder((String)"GetCurrentMetricDataRequest").add("InstanceId", (Object)this.instanceId()).add("Filters", (Object)this.filters()).add("Groupings", this.groupingsAsStrings()).add("CurrentMetrics", this.currentMetrics()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "Groupings": {
                return Optional.ofNullable(clazz.cast(this.groupingsAsStrings()));
            }
            case "CurrentMetrics": {
                return Optional.ofNullable(clazz.cast(this.currentMetrics()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCurrentMetricDataRequest, T> g) {
        return obj -> g.apply((GetCurrentMetricDataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private Filters filters;
        private List<String> groupings = DefaultSdkAutoConstructList.getInstance();
        private List<CurrentMetric> currentMetrics = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCurrentMetricDataRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.filters(model.filters);
            this.groupingsWithStrings(model.groupings);
            this.currentMetrics(model.currentMetrics);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Filters.Builder getFilters() {
            return this.filters != null ? this.filters.toBuilder() : null;
        }

        @Override
        public final Builder filters(Filters filters) {
            this.filters = filters;
            return this;
        }

        public final void setFilters(Filters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        public final Collection<String> getGroupingsAsStrings() {
            return this.groupings;
        }

        @Override
        public final Builder groupingsWithStrings(Collection<String> groupings) {
            this.groupings = GroupingsCopier.copy(groupings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupingsWithStrings(String ... groupings) {
            this.groupingsWithStrings(Arrays.asList(groupings));
            return this;
        }

        @Override
        public final Builder groupings(Collection<Grouping> groupings) {
            this.groupings = GroupingsCopier.copyEnumToString(groupings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupings(Grouping ... groupings) {
            this.groupings(Arrays.asList(groupings));
            return this;
        }

        public final void setGroupingsWithStrings(Collection<String> groupings) {
            this.groupings = GroupingsCopier.copy(groupings);
        }

        public final Collection<CurrentMetric.Builder> getCurrentMetrics() {
            return this.currentMetrics != null ? (Collection)this.currentMetrics.stream().map(CurrentMetric::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder currentMetrics(Collection<CurrentMetric> currentMetrics) {
            this.currentMetrics = CurrentMetricsCopier.copy(currentMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder currentMetrics(CurrentMetric ... currentMetrics) {
            this.currentMetrics(Arrays.asList(currentMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder currentMetrics(Consumer<CurrentMetric.Builder> ... currentMetrics) {
            this.currentMetrics(Stream.of(currentMetrics).map(c -> (CurrentMetric)((CurrentMetric.Builder)CurrentMetric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCurrentMetrics(Collection<CurrentMetric.BuilderImpl> currentMetrics) {
            this.currentMetrics = CurrentMetricsCopier.copyFromBuilder(currentMetrics);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCurrentMetricDataRequest build() {
            return new GetCurrentMetricDataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCurrentMetricDataRequest> {
        public Builder instanceId(String var1);

        public Builder filters(Filters var1);

        default public Builder filters(Consumer<Filters.Builder> filters) {
            return this.filters((Filters)((Filters.Builder)Filters.builder().applyMutation(filters)).build());
        }

        public Builder groupingsWithStrings(Collection<String> var1);

        public Builder groupingsWithStrings(String ... var1);

        public Builder groupings(Collection<Grouping> var1);

        public Builder groupings(Grouping ... var1);

        public Builder currentMetrics(Collection<CurrentMetric> var1);

        public Builder currentMetrics(CurrentMetric ... var1);

        public Builder currentMetrics(Consumer<CurrentMetric.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

