/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.CurrentMetricData;
import software.amazon.awssdk.services.connect.model.CurrentMetricDataCollectionsCopier;
import software.amazon.awssdk.services.connect.model.Dimensions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CurrentMetricResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CurrentMetricResult> {
    private static final SdkField<Dimensions> DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CurrentMetricResult.getter(CurrentMetricResult::dimensions)).setter(CurrentMetricResult.setter(Builder::dimensions)).constructor(Dimensions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimensions").build()}).build();
    private static final SdkField<List<CurrentMetricData>> COLLECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CurrentMetricResult.getter(CurrentMetricResult::collections)).setter(CurrentMetricResult.setter(Builder::collections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Collections").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CurrentMetricData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSIONS_FIELD, COLLECTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Dimensions dimensions;
    private final List<CurrentMetricData> collections;

    private CurrentMetricResult(BuilderImpl builder) {
        this.dimensions = builder.dimensions;
        this.collections = builder.collections;
    }

    public Dimensions dimensions() {
        return this.dimensions;
    }

    public List<CurrentMetricData> collections() {
        return this.collections;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dimensions());
        hashCode = 31 * hashCode + Objects.hashCode(this.collections());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CurrentMetricResult)) {
            return false;
        }
        CurrentMetricResult other = (CurrentMetricResult)obj;
        return Objects.equals(this.dimensions(), other.dimensions()) && Objects.equals(this.collections(), other.collections());
    }

    public String toString() {
        return ToString.builder((String)"CurrentMetricResult").add("Dimensions", (Object)this.dimensions()).add("Collections", this.collections()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Dimensions": {
                return Optional.ofNullable(clazz.cast(this.dimensions()));
            }
            case "Collections": {
                return Optional.ofNullable(clazz.cast(this.collections()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CurrentMetricResult, T> g) {
        return obj -> g.apply((CurrentMetricResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Dimensions dimensions;
        private List<CurrentMetricData> collections = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CurrentMetricResult model) {
            this.dimensions(model.dimensions);
            this.collections(model.collections);
        }

        public final Dimensions.Builder getDimensions() {
            return this.dimensions != null ? this.dimensions.toBuilder() : null;
        }

        @Override
        public final Builder dimensions(Dimensions dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public final void setDimensions(Dimensions.BuilderImpl dimensions) {
            this.dimensions = dimensions != null ? dimensions.build() : null;
        }

        public final Collection<CurrentMetricData.Builder> getCollections() {
            return this.collections != null ? (Collection)this.collections.stream().map(CurrentMetricData::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder collections(Collection<CurrentMetricData> collections) {
            this.collections = CurrentMetricDataCollectionsCopier.copy(collections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collections(CurrentMetricData ... collections) {
            this.collections(Arrays.asList(collections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collections(Consumer<CurrentMetricData.Builder> ... collections) {
            this.collections(Stream.of(collections).map(c -> (CurrentMetricData)((CurrentMetricData.Builder)CurrentMetricData.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCollections(Collection<CurrentMetricData.BuilderImpl> collections) {
            this.collections = CurrentMetricDataCollectionsCopier.copyFromBuilder(collections);
        }

        public CurrentMetricResult build() {
            return new CurrentMetricResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CurrentMetricResult> {
        public Builder dimensions(Dimensions var1);

        default public Builder dimensions(Consumer<Dimensions.Builder> dimensions) {
            return this.dimensions((Dimensions)((Dimensions.Builder)Dimensions.builder().applyMutation(dimensions)).build());
        }

        public Builder collections(Collection<CurrentMetricData> var1);

        public Builder collections(CurrentMetricData ... var1);

        public Builder collections(Consumer<CurrentMetricData.Builder> ... var1);
    }
}

