/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.HoursOfOperationOverride;
import software.amazon.awssdk.services.connect.model.SearchHoursOfOperationOverridesRequest;
import software.amazon.awssdk.services.connect.model.SearchHoursOfOperationOverridesResponse;

public class SearchHoursOfOperationOverridesPublisher
implements SdkPublisher<SearchHoursOfOperationOverridesResponse> {
    private final ConnectAsyncClient client;
    private final SearchHoursOfOperationOverridesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchHoursOfOperationOverridesPublisher(ConnectAsyncClient client, SearchHoursOfOperationOverridesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchHoursOfOperationOverridesPublisher(ConnectAsyncClient client, SearchHoursOfOperationOverridesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchHoursOfOperationOverridesResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchHoursOfOperationOverridesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<HoursOfOperationOverride> hoursOfOperationOverrides() {
        Function<SearchHoursOfOperationOverridesResponse, Iterator> getIterator = response -> {
            if (response != null && response.hoursOfOperationOverrides() != null) {
                return response.hoursOfOperationOverrides().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchHoursOfOperationOverridesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchHoursOfOperationOverridesResponseFetcher
    implements AsyncPageFetcher<SearchHoursOfOperationOverridesResponse> {
        private SearchHoursOfOperationOverridesResponseFetcher() {
        }

        public boolean hasNextPage(SearchHoursOfOperationOverridesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchHoursOfOperationOverridesResponse> nextPage(SearchHoursOfOperationOverridesResponse previousPage) {
            if (previousPage == null) {
                return SearchHoursOfOperationOverridesPublisher.this.client.searchHoursOfOperationOverrides(SearchHoursOfOperationOverridesPublisher.this.firstRequest);
            }
            return SearchHoursOfOperationOverridesPublisher.this.client.searchHoursOfOperationOverrides((SearchHoursOfOperationOverridesRequest)((Object)SearchHoursOfOperationOverridesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

