/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.SortOrder;
import software.amazon.awssdk.services.connect.model.SortableFieldName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Sort
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Sort> {
    private static final SdkField<String> FIELD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FieldName").getter(Sort.getter(Sort::fieldNameAsString)).setter(Sort.setter(Builder::fieldName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldName").build()}).build();
    private static final SdkField<String> ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Order").getter(Sort.getter(Sort::orderAsString)).setter(Sort.setter(Builder::order)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Order").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_NAME_FIELD, ORDER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Sort.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String fieldName;
    private final String order;

    private Sort(BuilderImpl builder) {
        this.fieldName = builder.fieldName;
        this.order = builder.order;
    }

    public final SortableFieldName fieldName() {
        return SortableFieldName.fromValue(this.fieldName);
    }

    public final String fieldNameAsString() {
        return this.fieldName;
    }

    public final SortOrder order() {
        return SortOrder.fromValue(this.order);
    }

    public final String orderAsString() {
        return this.order;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.orderAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Sort)) {
            return false;
        }
        Sort other = (Sort)obj;
        return Objects.equals(this.fieldNameAsString(), other.fieldNameAsString()) && Objects.equals(this.orderAsString(), other.orderAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Sort").add("FieldName", (Object)this.fieldNameAsString()).add("Order", (Object)this.orderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FieldName": {
                return Optional.ofNullable(clazz.cast(this.fieldNameAsString()));
            }
            case "Order": {
                return Optional.ofNullable(clazz.cast(this.orderAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("FieldName", FIELD_NAME_FIELD);
        map.put("Order", ORDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Sort, T> g) {
        return obj -> g.apply((Sort)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fieldName;
        private String order;

        private BuilderImpl() {
        }

        private BuilderImpl(Sort model) {
            this.fieldName(model.fieldName);
            this.order(model.order);
        }

        public final String getFieldName() {
            return this.fieldName;
        }

        public final void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public final Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        @Override
        public final Builder fieldName(SortableFieldName fieldName) {
            this.fieldName(fieldName == null ? null : fieldName.toString());
            return this;
        }

        public final String getOrder() {
            return this.order;
        }

        public final void setOrder(String order) {
            this.order = order;
        }

        @Override
        public final Builder order(String order) {
            this.order = order;
            return this;
        }

        @Override
        public final Builder order(SortOrder order) {
            this.order(order == null ? null : order.toString());
            return this;
        }

        public Sort build() {
            return new Sort(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Sort> {
        public Builder fieldName(String var1);

        public Builder fieldName(SortableFieldName var1);

        public Builder order(String var1);

        public Builder order(SortOrder var1);
    }
}

