/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.AttributesCopier;
import software.amazon.awssdk.services.connect.model.ChatMessage;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.Endpoint;
import software.amazon.awssdk.services.connect.model.ParticipantDetails;
import software.amazon.awssdk.services.connect.model.SegmentAttributeValue;
import software.amazon.awssdk.services.connect.model.SegmentAttributesCopier;
import software.amazon.awssdk.services.connect.model.SupportedMessagingContentTypesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartOutboundChatContactRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, StartOutboundChatContactRequest> {
    private static final SdkField<Endpoint> SOURCE_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceEndpoint").getter(StartOutboundChatContactRequest.getter(StartOutboundChatContactRequest::sourceEndpoint)).setter(StartOutboundChatContactRequest.setter(Builder::sourceEndpoint)).constructor(Endpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceEndpoint").build()}).build();
    private static final SdkField<Endpoint> DESTINATION_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationEndpoint").getter(StartOutboundChatContactRequest.getter(StartOutboundChatContactRequest::destinationEndpoint)).setter(StartOutboundChatContactRequest.setter(Builder::destinationEndpoint)).constructor(Endpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationEndpoint").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(StartOutboundChatContactRequest.getter(StartOutboundChatContactRequest::instanceId)).setter(StartOutboundChatContactRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<Map<String, SegmentAttributeValue>> SEGMENT_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("SegmentAttributes").getter(StartOutboundChatContactRequest.getter(StartOutboundChatContactRequest::segmentAttributes)).setter(StartOutboundChatContactRequest.setter(Builder::segmentAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SegmentAttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Attributes").getter(StartOutboundChatContactRequest.getter(StartOutboundChatContactRequest::attributes)).setter(StartOutboundChatContactRequest.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CONTACT_FLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactFlowId").getter(StartOutboundChatContactRequest.getter(StartOutboundChatContactRequest::contactFlowId)).setter(StartOutboundChatContactRequest.setter(Builder::contactFlowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFlowId").build()}).build();
    private static final SdkField<Integer> CHAT_DURATION_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ChatDurationInMinutes").getter(StartOutboundChatContactRequest.getter(StartOutboundChatContactRequest::chatDurationInMinutes)).setter(StartOutboundChatContactRequest.setter(Builder::chatDurationInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChatDurationInMinutes").build()}).build();
    private static final SdkField<ParticipantDetails> PARTICIPANT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ParticipantDetails").getter(StartOutboundChatContactRequest.getter(StartOutboundChatContactRequest::participantDetails)).setter(StartOutboundChatContactRequest.setter(Builder::participantDetails)).constructor(ParticipantDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantDetails").build()}).build();
    private static final SdkField<ChatMessage> INITIAL_SYSTEM_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InitialSystemMessage").getter(StartOutboundChatContactRequest.getter(StartOutboundChatContactRequest::initialSystemMessage)).setter(StartOutboundChatContactRequest.setter(Builder::initialSystemMessage)).constructor(ChatMessage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitialSystemMessage").build()}).build();
    private static final SdkField<String> RELATED_CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RelatedContactId").getter(StartOutboundChatContactRequest.getter(StartOutboundChatContactRequest::relatedContactId)).setter(StartOutboundChatContactRequest.setter(Builder::relatedContactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedContactId").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_MESSAGING_CONTENT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedMessagingContentTypes").getter(StartOutboundChatContactRequest.getter(StartOutboundChatContactRequest::supportedMessagingContentTypes)).setter(StartOutboundChatContactRequest.setter(Builder::supportedMessagingContentTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedMessagingContentTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(StartOutboundChatContactRequest.getter(StartOutboundChatContactRequest::clientToken)).setter(StartOutboundChatContactRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ENDPOINT_FIELD, DESTINATION_ENDPOINT_FIELD, INSTANCE_ID_FIELD, SEGMENT_ATTRIBUTES_FIELD, ATTRIBUTES_FIELD, CONTACT_FLOW_ID_FIELD, CHAT_DURATION_IN_MINUTES_FIELD, PARTICIPANT_DETAILS_FIELD, INITIAL_SYSTEM_MESSAGE_FIELD, RELATED_CONTACT_ID_FIELD, SUPPORTED_MESSAGING_CONTENT_TYPES_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartOutboundChatContactRequest.memberNameToFieldInitializer();
    private final Endpoint sourceEndpoint;
    private final Endpoint destinationEndpoint;
    private final String instanceId;
    private final Map<String, SegmentAttributeValue> segmentAttributes;
    private final Map<String, String> attributes;
    private final String contactFlowId;
    private final Integer chatDurationInMinutes;
    private final ParticipantDetails participantDetails;
    private final ChatMessage initialSystemMessage;
    private final String relatedContactId;
    private final List<String> supportedMessagingContentTypes;
    private final String clientToken;

    private StartOutboundChatContactRequest(BuilderImpl builder) {
        super(builder);
        this.sourceEndpoint = builder.sourceEndpoint;
        this.destinationEndpoint = builder.destinationEndpoint;
        this.instanceId = builder.instanceId;
        this.segmentAttributes = builder.segmentAttributes;
        this.attributes = builder.attributes;
        this.contactFlowId = builder.contactFlowId;
        this.chatDurationInMinutes = builder.chatDurationInMinutes;
        this.participantDetails = builder.participantDetails;
        this.initialSystemMessage = builder.initialSystemMessage;
        this.relatedContactId = builder.relatedContactId;
        this.supportedMessagingContentTypes = builder.supportedMessagingContentTypes;
        this.clientToken = builder.clientToken;
    }

    public final Endpoint sourceEndpoint() {
        return this.sourceEndpoint;
    }

    public final Endpoint destinationEndpoint() {
        return this.destinationEndpoint;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final boolean hasSegmentAttributes() {
        return this.segmentAttributes != null && !(this.segmentAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, SegmentAttributeValue> segmentAttributes() {
        return this.segmentAttributes;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    public final String contactFlowId() {
        return this.contactFlowId;
    }

    public final Integer chatDurationInMinutes() {
        return this.chatDurationInMinutes;
    }

    public final ParticipantDetails participantDetails() {
        return this.participantDetails;
    }

    public final ChatMessage initialSystemMessage() {
        return this.initialSystemMessage;
    }

    public final String relatedContactId() {
        return this.relatedContactId;
    }

    public final boolean hasSupportedMessagingContentTypes() {
        return this.supportedMessagingContentTypes != null && !(this.supportedMessagingContentTypes instanceof SdkAutoConstructList);
    }

    public final List<String> supportedMessagingContentTypes() {
        return this.supportedMessagingContentTypes;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSegmentAttributes() ? this.segmentAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.contactFlowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.chatDurationInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.participantDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.initialSystemMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.relatedContactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedMessagingContentTypes() ? this.supportedMessagingContentTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartOutboundChatContactRequest)) {
            return false;
        }
        StartOutboundChatContactRequest other = (StartOutboundChatContactRequest)((Object)obj);
        return Objects.equals(this.sourceEndpoint(), other.sourceEndpoint()) && Objects.equals(this.destinationEndpoint(), other.destinationEndpoint()) && Objects.equals(this.instanceId(), other.instanceId()) && this.hasSegmentAttributes() == other.hasSegmentAttributes() && Objects.equals(this.segmentAttributes(), other.segmentAttributes()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.contactFlowId(), other.contactFlowId()) && Objects.equals(this.chatDurationInMinutes(), other.chatDurationInMinutes()) && Objects.equals(this.participantDetails(), other.participantDetails()) && Objects.equals(this.initialSystemMessage(), other.initialSystemMessage()) && Objects.equals(this.relatedContactId(), other.relatedContactId()) && this.hasSupportedMessagingContentTypes() == other.hasSupportedMessagingContentTypes() && Objects.equals(this.supportedMessagingContentTypes(), other.supportedMessagingContentTypes()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"StartOutboundChatContactRequest").add("SourceEndpoint", (Object)this.sourceEndpoint()).add("DestinationEndpoint", (Object)this.destinationEndpoint()).add("InstanceId", (Object)this.instanceId()).add("SegmentAttributes", this.hasSegmentAttributes() ? this.segmentAttributes() : null).add("Attributes", this.hasAttributes() ? this.attributes() : null).add("ContactFlowId", (Object)this.contactFlowId()).add("ChatDurationInMinutes", (Object)this.chatDurationInMinutes()).add("ParticipantDetails", (Object)this.participantDetails()).add("InitialSystemMessage", (Object)this.initialSystemMessage()).add("RelatedContactId", (Object)this.relatedContactId()).add("SupportedMessagingContentTypes", this.hasSupportedMessagingContentTypes() ? this.supportedMessagingContentTypes() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceEndpoint": {
                return Optional.ofNullable(clazz.cast(this.sourceEndpoint()));
            }
            case "DestinationEndpoint": {
                return Optional.ofNullable(clazz.cast(this.destinationEndpoint()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "SegmentAttributes": {
                return Optional.ofNullable(clazz.cast(this.segmentAttributes()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "ContactFlowId": {
                return Optional.ofNullable(clazz.cast(this.contactFlowId()));
            }
            case "ChatDurationInMinutes": {
                return Optional.ofNullable(clazz.cast(this.chatDurationInMinutes()));
            }
            case "ParticipantDetails": {
                return Optional.ofNullable(clazz.cast(this.participantDetails()));
            }
            case "InitialSystemMessage": {
                return Optional.ofNullable(clazz.cast(this.initialSystemMessage()));
            }
            case "RelatedContactId": {
                return Optional.ofNullable(clazz.cast(this.relatedContactId()));
            }
            case "SupportedMessagingContentTypes": {
                return Optional.ofNullable(clazz.cast(this.supportedMessagingContentTypes()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SourceEndpoint", SOURCE_ENDPOINT_FIELD);
        map.put("DestinationEndpoint", DESTINATION_ENDPOINT_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("SegmentAttributes", SEGMENT_ATTRIBUTES_FIELD);
        map.put("Attributes", ATTRIBUTES_FIELD);
        map.put("ContactFlowId", CONTACT_FLOW_ID_FIELD);
        map.put("ChatDurationInMinutes", CHAT_DURATION_IN_MINUTES_FIELD);
        map.put("ParticipantDetails", PARTICIPANT_DETAILS_FIELD);
        map.put("InitialSystemMessage", INITIAL_SYSTEM_MESSAGE_FIELD);
        map.put("RelatedContactId", RELATED_CONTACT_ID_FIELD);
        map.put("SupportedMessagingContentTypes", SUPPORTED_MESSAGING_CONTENT_TYPES_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartOutboundChatContactRequest, T> g) {
        return obj -> g.apply((StartOutboundChatContactRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private Endpoint sourceEndpoint;
        private Endpoint destinationEndpoint;
        private String instanceId;
        private Map<String, SegmentAttributeValue> segmentAttributes = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();
        private String contactFlowId;
        private Integer chatDurationInMinutes;
        private ParticipantDetails participantDetails;
        private ChatMessage initialSystemMessage;
        private String relatedContactId;
        private List<String> supportedMessagingContentTypes = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartOutboundChatContactRequest model) {
            super(model);
            this.sourceEndpoint(model.sourceEndpoint);
            this.destinationEndpoint(model.destinationEndpoint);
            this.instanceId(model.instanceId);
            this.segmentAttributes(model.segmentAttributes);
            this.attributes(model.attributes);
            this.contactFlowId(model.contactFlowId);
            this.chatDurationInMinutes(model.chatDurationInMinutes);
            this.participantDetails(model.participantDetails);
            this.initialSystemMessage(model.initialSystemMessage);
            this.relatedContactId(model.relatedContactId);
            this.supportedMessagingContentTypes(model.supportedMessagingContentTypes);
            this.clientToken(model.clientToken);
        }

        public final Endpoint.Builder getSourceEndpoint() {
            return this.sourceEndpoint != null ? this.sourceEndpoint.toBuilder() : null;
        }

        public final void setSourceEndpoint(Endpoint.BuilderImpl sourceEndpoint) {
            this.sourceEndpoint = sourceEndpoint != null ? sourceEndpoint.build() : null;
        }

        @Override
        public final Builder sourceEndpoint(Endpoint sourceEndpoint) {
            this.sourceEndpoint = sourceEndpoint;
            return this;
        }

        public final Endpoint.Builder getDestinationEndpoint() {
            return this.destinationEndpoint != null ? this.destinationEndpoint.toBuilder() : null;
        }

        public final void setDestinationEndpoint(Endpoint.BuilderImpl destinationEndpoint) {
            this.destinationEndpoint = destinationEndpoint != null ? destinationEndpoint.build() : null;
        }

        @Override
        public final Builder destinationEndpoint(Endpoint destinationEndpoint) {
            this.destinationEndpoint = destinationEndpoint;
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final Map<String, SegmentAttributeValue.Builder> getSegmentAttributes() {
            Map<String, SegmentAttributeValue.Builder> result = SegmentAttributesCopier.copyToBuilder(this.segmentAttributes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setSegmentAttributes(Map<String, SegmentAttributeValue.BuilderImpl> segmentAttributes) {
            this.segmentAttributes = SegmentAttributesCopier.copyFromBuilder(segmentAttributes);
        }

        @Override
        public final Builder segmentAttributes(Map<String, SegmentAttributeValue> segmentAttributes) {
            this.segmentAttributes = SegmentAttributesCopier.copy(segmentAttributes);
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final String getContactFlowId() {
            return this.contactFlowId;
        }

        public final void setContactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
        }

        @Override
        public final Builder contactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
            return this;
        }

        public final Integer getChatDurationInMinutes() {
            return this.chatDurationInMinutes;
        }

        public final void setChatDurationInMinutes(Integer chatDurationInMinutes) {
            this.chatDurationInMinutes = chatDurationInMinutes;
        }

        @Override
        public final Builder chatDurationInMinutes(Integer chatDurationInMinutes) {
            this.chatDurationInMinutes = chatDurationInMinutes;
            return this;
        }

        public final ParticipantDetails.Builder getParticipantDetails() {
            return this.participantDetails != null ? this.participantDetails.toBuilder() : null;
        }

        public final void setParticipantDetails(ParticipantDetails.BuilderImpl participantDetails) {
            this.participantDetails = participantDetails != null ? participantDetails.build() : null;
        }

        @Override
        public final Builder participantDetails(ParticipantDetails participantDetails) {
            this.participantDetails = participantDetails;
            return this;
        }

        public final ChatMessage.Builder getInitialSystemMessage() {
            return this.initialSystemMessage != null ? this.initialSystemMessage.toBuilder() : null;
        }

        public final void setInitialSystemMessage(ChatMessage.BuilderImpl initialSystemMessage) {
            this.initialSystemMessage = initialSystemMessage != null ? initialSystemMessage.build() : null;
        }

        @Override
        public final Builder initialSystemMessage(ChatMessage initialSystemMessage) {
            this.initialSystemMessage = initialSystemMessage;
            return this;
        }

        public final String getRelatedContactId() {
            return this.relatedContactId;
        }

        public final void setRelatedContactId(String relatedContactId) {
            this.relatedContactId = relatedContactId;
        }

        @Override
        public final Builder relatedContactId(String relatedContactId) {
            this.relatedContactId = relatedContactId;
            return this;
        }

        public final Collection<String> getSupportedMessagingContentTypes() {
            if (this.supportedMessagingContentTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedMessagingContentTypes;
        }

        public final void setSupportedMessagingContentTypes(Collection<String> supportedMessagingContentTypes) {
            this.supportedMessagingContentTypes = SupportedMessagingContentTypesCopier.copy(supportedMessagingContentTypes);
        }

        @Override
        public final Builder supportedMessagingContentTypes(Collection<String> supportedMessagingContentTypes) {
            this.supportedMessagingContentTypes = SupportedMessagingContentTypesCopier.copy(supportedMessagingContentTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedMessagingContentTypes(String ... supportedMessagingContentTypes) {
            this.supportedMessagingContentTypes(Arrays.asList(supportedMessagingContentTypes));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartOutboundChatContactRequest build() {
            return new StartOutboundChatContactRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartOutboundChatContactRequest> {
        public Builder sourceEndpoint(Endpoint var1);

        default public Builder sourceEndpoint(Consumer<Endpoint.Builder> sourceEndpoint) {
            return this.sourceEndpoint((Endpoint)((Endpoint.Builder)Endpoint.builder().applyMutation(sourceEndpoint)).build());
        }

        public Builder destinationEndpoint(Endpoint var1);

        default public Builder destinationEndpoint(Consumer<Endpoint.Builder> destinationEndpoint) {
            return this.destinationEndpoint((Endpoint)((Endpoint.Builder)Endpoint.builder().applyMutation(destinationEndpoint)).build());
        }

        public Builder instanceId(String var1);

        public Builder segmentAttributes(Map<String, SegmentAttributeValue> var1);

        public Builder attributes(Map<String, String> var1);

        public Builder contactFlowId(String var1);

        public Builder chatDurationInMinutes(Integer var1);

        public Builder participantDetails(ParticipantDetails var1);

        default public Builder participantDetails(Consumer<ParticipantDetails.Builder> participantDetails) {
            return this.participantDetails((ParticipantDetails)((ParticipantDetails.Builder)ParticipantDetails.builder().applyMutation(participantDetails)).build());
        }

        public Builder initialSystemMessage(ChatMessage var1);

        default public Builder initialSystemMessage(Consumer<ChatMessage.Builder> initialSystemMessage) {
            return this.initialSystemMessage((ChatMessage)((ChatMessage.Builder)ChatMessage.builder().applyMutation(initialSystemMessage)).build());
        }

        public Builder relatedContactId(String var1);

        public Builder supportedMessagingContentTypes(Collection<String> var1);

        public Builder supportedMessagingContentTypes(String ... var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

