/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.PhoneNumberCountryCode;
import software.amazon.awssdk.services.connect.model.PhoneNumberCountryCodesCopier;
import software.amazon.awssdk.services.connect.model.PhoneNumberType;
import software.amazon.awssdk.services.connect.model.PhoneNumberTypesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPhoneNumbersRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, ListPhoneNumbersRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(ListPhoneNumbersRequest.getter(ListPhoneNumbersRequest::instanceId)).setter(ListPhoneNumbersRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<List<String>> PHONE_NUMBER_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PhoneNumberTypes").getter(ListPhoneNumbersRequest.getter(ListPhoneNumbersRequest::phoneNumberTypesAsStrings)).setter(ListPhoneNumbersRequest.setter(Builder::phoneNumberTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("phoneNumberTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PHONE_NUMBER_COUNTRY_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PhoneNumberCountryCodes").getter(ListPhoneNumbersRequest.getter(ListPhoneNumbersRequest::phoneNumberCountryCodesAsStrings)).setter(ListPhoneNumbersRequest.setter(Builder::phoneNumberCountryCodesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("phoneNumberCountryCodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListPhoneNumbersRequest.getter(ListPhoneNumbersRequest::nextToken)).setter(ListPhoneNumbersRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListPhoneNumbersRequest.getter(ListPhoneNumbersRequest::maxResults)).setter(ListPhoneNumbersRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, PHONE_NUMBER_TYPES_FIELD, PHONE_NUMBER_COUNTRY_CODES_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListPhoneNumbersRequest.memberNameToFieldInitializer();
    private final String instanceId;
    private final List<String> phoneNumberTypes;
    private final List<String> phoneNumberCountryCodes;
    private final String nextToken;
    private final Integer maxResults;

    private ListPhoneNumbersRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.phoneNumberTypes = builder.phoneNumberTypes;
        this.phoneNumberCountryCodes = builder.phoneNumberCountryCodes;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final List<PhoneNumberType> phoneNumberTypes() {
        return PhoneNumberTypesCopier.copyStringToEnum(this.phoneNumberTypes);
    }

    public final boolean hasPhoneNumberTypes() {
        return this.phoneNumberTypes != null && !(this.phoneNumberTypes instanceof SdkAutoConstructList);
    }

    public final List<String> phoneNumberTypesAsStrings() {
        return this.phoneNumberTypes;
    }

    public final List<PhoneNumberCountryCode> phoneNumberCountryCodes() {
        return PhoneNumberCountryCodesCopier.copyStringToEnum(this.phoneNumberCountryCodes);
    }

    public final boolean hasPhoneNumberCountryCodes() {
        return this.phoneNumberCountryCodes != null && !(this.phoneNumberCountryCodes instanceof SdkAutoConstructList);
    }

    public final List<String> phoneNumberCountryCodesAsStrings() {
        return this.phoneNumberCountryCodes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhoneNumberTypes() ? this.phoneNumberTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhoneNumberCountryCodes() ? this.phoneNumberCountryCodesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPhoneNumbersRequest)) {
            return false;
        }
        ListPhoneNumbersRequest other = (ListPhoneNumbersRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && this.hasPhoneNumberTypes() == other.hasPhoneNumberTypes() && Objects.equals(this.phoneNumberTypesAsStrings(), other.phoneNumberTypesAsStrings()) && this.hasPhoneNumberCountryCodes() == other.hasPhoneNumberCountryCodes() && Objects.equals(this.phoneNumberCountryCodesAsStrings(), other.phoneNumberCountryCodesAsStrings()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListPhoneNumbersRequest").add("InstanceId", (Object)this.instanceId()).add("PhoneNumberTypes", this.hasPhoneNumberTypes() ? this.phoneNumberTypesAsStrings() : null).add("PhoneNumberCountryCodes", this.hasPhoneNumberCountryCodes() ? this.phoneNumberCountryCodesAsStrings() : null).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "PhoneNumberTypes": {
                return Optional.ofNullable(clazz.cast(this.phoneNumberTypesAsStrings()));
            }
            case "PhoneNumberCountryCodes": {
                return Optional.ofNullable(clazz.cast(this.phoneNumberCountryCodesAsStrings()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("phoneNumberTypes", PHONE_NUMBER_TYPES_FIELD);
        map.put("phoneNumberCountryCodes", PHONE_NUMBER_COUNTRY_CODES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPhoneNumbersRequest, T> g) {
        return obj -> g.apply((ListPhoneNumbersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private List<String> phoneNumberTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> phoneNumberCountryCodes = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPhoneNumbersRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.phoneNumberTypesWithStrings(model.phoneNumberTypes);
            this.phoneNumberCountryCodesWithStrings(model.phoneNumberCountryCodes);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final Collection<String> getPhoneNumberTypes() {
            if (this.phoneNumberTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.phoneNumberTypes;
        }

        public final void setPhoneNumberTypes(Collection<String> phoneNumberTypes) {
            this.phoneNumberTypes = PhoneNumberTypesCopier.copy(phoneNumberTypes);
        }

        @Override
        public final Builder phoneNumberTypesWithStrings(Collection<String> phoneNumberTypes) {
            this.phoneNumberTypes = PhoneNumberTypesCopier.copy(phoneNumberTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumberTypesWithStrings(String ... phoneNumberTypes) {
            this.phoneNumberTypesWithStrings(Arrays.asList(phoneNumberTypes));
            return this;
        }

        @Override
        public final Builder phoneNumberTypes(Collection<PhoneNumberType> phoneNumberTypes) {
            this.phoneNumberTypes = PhoneNumberTypesCopier.copyEnumToString(phoneNumberTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumberTypes(PhoneNumberType ... phoneNumberTypes) {
            this.phoneNumberTypes(Arrays.asList(phoneNumberTypes));
            return this;
        }

        public final Collection<String> getPhoneNumberCountryCodes() {
            if (this.phoneNumberCountryCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.phoneNumberCountryCodes;
        }

        public final void setPhoneNumberCountryCodes(Collection<String> phoneNumberCountryCodes) {
            this.phoneNumberCountryCodes = PhoneNumberCountryCodesCopier.copy(phoneNumberCountryCodes);
        }

        @Override
        public final Builder phoneNumberCountryCodesWithStrings(Collection<String> phoneNumberCountryCodes) {
            this.phoneNumberCountryCodes = PhoneNumberCountryCodesCopier.copy(phoneNumberCountryCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumberCountryCodesWithStrings(String ... phoneNumberCountryCodes) {
            this.phoneNumberCountryCodesWithStrings(Arrays.asList(phoneNumberCountryCodes));
            return this;
        }

        @Override
        public final Builder phoneNumberCountryCodes(Collection<PhoneNumberCountryCode> phoneNumberCountryCodes) {
            this.phoneNumberCountryCodes = PhoneNumberCountryCodesCopier.copyEnumToString(phoneNumberCountryCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumberCountryCodes(PhoneNumberCountryCode ... phoneNumberCountryCodes) {
            this.phoneNumberCountryCodes(Arrays.asList(phoneNumberCountryCodes));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPhoneNumbersRequest build() {
            return new ListPhoneNumbersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPhoneNumbersRequest> {
        public Builder instanceId(String var1);

        public Builder phoneNumberTypesWithStrings(Collection<String> var1);

        public Builder phoneNumberTypesWithStrings(String ... var1);

        public Builder phoneNumberTypes(Collection<PhoneNumberType> var1);

        public Builder phoneNumberTypes(PhoneNumberType ... var1);

        public Builder phoneNumberCountryCodesWithStrings(Collection<String> var1);

        public Builder phoneNumberCountryCodesWithStrings(String ... var1);

        public Builder phoneNumberCountryCodes(Collection<PhoneNumberCountryCode> var1);

        public Builder phoneNumberCountryCodes(PhoneNumberCountryCode ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

