/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectResponse;
import software.amazon.awssdk.services.connect.model.HoursOfOperationOverride;
import software.amazon.awssdk.services.connect.model.HoursOfOperationOverrideListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListHoursOfOperationOverridesResponse
extends ConnectResponse
implements ToCopyableBuilder<Builder, ListHoursOfOperationOverridesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListHoursOfOperationOverridesResponse.getter(ListHoursOfOperationOverridesResponse::nextToken)).setter(ListHoursOfOperationOverridesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<HoursOfOperationOverride>> HOURS_OF_OPERATION_OVERRIDE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HoursOfOperationOverrideList").getter(ListHoursOfOperationOverridesResponse.getter(ListHoursOfOperationOverridesResponse::hoursOfOperationOverrideList)).setter(ListHoursOfOperationOverridesResponse.setter(Builder::hoursOfOperationOverrideList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HoursOfOperationOverrideList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HoursOfOperationOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LAST_MODIFIED_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModifiedRegion").getter(ListHoursOfOperationOverridesResponse.getter(ListHoursOfOperationOverridesResponse::lastModifiedRegion)).setter(ListHoursOfOperationOverridesResponse.setter(Builder::lastModifiedRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedRegion").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(ListHoursOfOperationOverridesResponse.getter(ListHoursOfOperationOverridesResponse::lastModifiedTime)).setter(ListHoursOfOperationOverridesResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, HOURS_OF_OPERATION_OVERRIDE_LIST_FIELD, LAST_MODIFIED_REGION_FIELD, LAST_MODIFIED_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListHoursOfOperationOverridesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<HoursOfOperationOverride> hoursOfOperationOverrideList;
    private final String lastModifiedRegion;
    private final Instant lastModifiedTime;

    private ListHoursOfOperationOverridesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.hoursOfOperationOverrideList = builder.hoursOfOperationOverrideList;
        this.lastModifiedRegion = builder.lastModifiedRegion;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasHoursOfOperationOverrideList() {
        return this.hoursOfOperationOverrideList != null && !(this.hoursOfOperationOverrideList instanceof SdkAutoConstructList);
    }

    public final List<HoursOfOperationOverride> hoursOfOperationOverrideList() {
        return this.hoursOfOperationOverrideList;
    }

    public final String lastModifiedRegion() {
        return this.lastModifiedRegion;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHoursOfOperationOverrideList() ? this.hoursOfOperationOverrideList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHoursOfOperationOverridesResponse)) {
            return false;
        }
        ListHoursOfOperationOverridesResponse other = (ListHoursOfOperationOverridesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasHoursOfOperationOverrideList() == other.hasHoursOfOperationOverrideList() && Objects.equals(this.hoursOfOperationOverrideList(), other.hoursOfOperationOverrideList()) && Objects.equals(this.lastModifiedRegion(), other.lastModifiedRegion()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime());
    }

    public final String toString() {
        return ToString.builder((String)"ListHoursOfOperationOverridesResponse").add("NextToken", (Object)this.nextToken()).add("HoursOfOperationOverrideList", this.hasHoursOfOperationOverrideList() ? this.hoursOfOperationOverrideList() : null).add("LastModifiedRegion", (Object)this.lastModifiedRegion()).add("LastModifiedTime", (Object)this.lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "HoursOfOperationOverrideList": {
                return Optional.ofNullable(clazz.cast(this.hoursOfOperationOverrideList()));
            }
            case "LastModifiedRegion": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedRegion()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("HoursOfOperationOverrideList", HOURS_OF_OPERATION_OVERRIDE_LIST_FIELD);
        map.put("LastModifiedRegion", LAST_MODIFIED_REGION_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListHoursOfOperationOverridesResponse, T> g) {
        return obj -> g.apply((ListHoursOfOperationOverridesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<HoursOfOperationOverride> hoursOfOperationOverrideList = DefaultSdkAutoConstructList.getInstance();
        private String lastModifiedRegion;
        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHoursOfOperationOverridesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.hoursOfOperationOverrideList(model.hoursOfOperationOverrideList);
            this.lastModifiedRegion(model.lastModifiedRegion);
            this.lastModifiedTime(model.lastModifiedTime);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<HoursOfOperationOverride.Builder> getHoursOfOperationOverrideList() {
            List<HoursOfOperationOverride.Builder> result = HoursOfOperationOverrideListCopier.copyToBuilder(this.hoursOfOperationOverrideList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHoursOfOperationOverrideList(Collection<HoursOfOperationOverride.BuilderImpl> hoursOfOperationOverrideList) {
            this.hoursOfOperationOverrideList = HoursOfOperationOverrideListCopier.copyFromBuilder(hoursOfOperationOverrideList);
        }

        @Override
        public final Builder hoursOfOperationOverrideList(Collection<HoursOfOperationOverride> hoursOfOperationOverrideList) {
            this.hoursOfOperationOverrideList = HoursOfOperationOverrideListCopier.copy(hoursOfOperationOverrideList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hoursOfOperationOverrideList(HoursOfOperationOverride ... hoursOfOperationOverrideList) {
            this.hoursOfOperationOverrideList(Arrays.asList(hoursOfOperationOverrideList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hoursOfOperationOverrideList(Consumer<HoursOfOperationOverride.Builder> ... hoursOfOperationOverrideList) {
            this.hoursOfOperationOverrideList(Stream.of(hoursOfOperationOverrideList).map(c -> (HoursOfOperationOverride)((HoursOfOperationOverride.Builder)HoursOfOperationOverride.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getLastModifiedRegion() {
            return this.lastModifiedRegion;
        }

        public final void setLastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
        }

        @Override
        public final Builder lastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        @Override
        public ListHoursOfOperationOverridesResponse build() {
            return new ListHoursOfOperationOverridesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListHoursOfOperationOverridesResponse> {
        public Builder nextToken(String var1);

        public Builder hoursOfOperationOverrideList(Collection<HoursOfOperationOverride> var1);

        public Builder hoursOfOperationOverrideList(HoursOfOperationOverride ... var1);

        public Builder hoursOfOperationOverrideList(Consumer<HoursOfOperationOverride.Builder> ... var1);

        public Builder lastModifiedRegion(String var1);

        public Builder lastModifiedTime(Instant var1);
    }
}

