/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ContactFlowModuleSearchConditionListCopier;
import software.amazon.awssdk.services.connect.model.ContactFlowModuleState;
import software.amazon.awssdk.services.connect.model.ContactFlowModuleStatus;
import software.amazon.awssdk.services.connect.model.StringCondition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContactFlowModuleSearchCriteria
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContactFlowModuleSearchCriteria> {
    private static final SdkField<List<ContactFlowModuleSearchCriteria>> OR_CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OrConditions").getter(ContactFlowModuleSearchCriteria.getter(ContactFlowModuleSearchCriteria::orConditions)).setter(ContactFlowModuleSearchCriteria.setter(Builder::orConditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrConditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContactFlowModuleSearchCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ContactFlowModuleSearchCriteria>> AND_CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AndConditions").getter(ContactFlowModuleSearchCriteria.getter(ContactFlowModuleSearchCriteria::andConditions)).setter(ContactFlowModuleSearchCriteria.setter(Builder::andConditions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AndConditions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContactFlowModuleSearchCriteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<StringCondition> STRING_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StringCondition").getter(ContactFlowModuleSearchCriteria.getter(ContactFlowModuleSearchCriteria::stringCondition)).setter(ContactFlowModuleSearchCriteria.setter(Builder::stringCondition)).constructor(StringCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringCondition").build()}).build();
    private static final SdkField<String> STATE_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateCondition").getter(ContactFlowModuleSearchCriteria.getter(ContactFlowModuleSearchCriteria::stateConditionAsString)).setter(ContactFlowModuleSearchCriteria.setter(Builder::stateCondition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateCondition").build()}).build();
    private static final SdkField<String> STATUS_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusCondition").getter(ContactFlowModuleSearchCriteria.getter(ContactFlowModuleSearchCriteria::statusConditionAsString)).setter(ContactFlowModuleSearchCriteria.setter(Builder::statusCondition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCondition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OR_CONDITIONS_FIELD, AND_CONDITIONS_FIELD, STRING_CONDITION_FIELD, STATE_CONDITION_FIELD, STATUS_CONDITION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ContactFlowModuleSearchCriteria.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<ContactFlowModuleSearchCriteria> orConditions;
    private final List<ContactFlowModuleSearchCriteria> andConditions;
    private final StringCondition stringCondition;
    private final String stateCondition;
    private final String statusCondition;

    private ContactFlowModuleSearchCriteria(BuilderImpl builder) {
        this.orConditions = builder.orConditions;
        this.andConditions = builder.andConditions;
        this.stringCondition = builder.stringCondition;
        this.stateCondition = builder.stateCondition;
        this.statusCondition = builder.statusCondition;
    }

    public final boolean hasOrConditions() {
        return this.orConditions != null && !(this.orConditions instanceof SdkAutoConstructList);
    }

    public final List<ContactFlowModuleSearchCriteria> orConditions() {
        return this.orConditions;
    }

    public final boolean hasAndConditions() {
        return this.andConditions != null && !(this.andConditions instanceof SdkAutoConstructList);
    }

    public final List<ContactFlowModuleSearchCriteria> andConditions() {
        return this.andConditions;
    }

    public final StringCondition stringCondition() {
        return this.stringCondition;
    }

    public final ContactFlowModuleState stateCondition() {
        return ContactFlowModuleState.fromValue(this.stateCondition);
    }

    public final String stateConditionAsString() {
        return this.stateCondition;
    }

    public final ContactFlowModuleStatus statusCondition() {
        return ContactFlowModuleStatus.fromValue(this.statusCondition);
    }

    public final String statusConditionAsString() {
        return this.statusCondition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrConditions() ? this.orConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAndConditions() ? this.andConditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stringCondition());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateConditionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusConditionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactFlowModuleSearchCriteria)) {
            return false;
        }
        ContactFlowModuleSearchCriteria other = (ContactFlowModuleSearchCriteria)obj;
        return this.hasOrConditions() == other.hasOrConditions() && Objects.equals(this.orConditions(), other.orConditions()) && this.hasAndConditions() == other.hasAndConditions() && Objects.equals(this.andConditions(), other.andConditions()) && Objects.equals(this.stringCondition(), other.stringCondition()) && Objects.equals(this.stateConditionAsString(), other.stateConditionAsString()) && Objects.equals(this.statusConditionAsString(), other.statusConditionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ContactFlowModuleSearchCriteria").add("OrConditions", this.hasOrConditions() ? this.orConditions() : null).add("AndConditions", this.hasAndConditions() ? this.andConditions() : null).add("StringCondition", (Object)this.stringCondition()).add("StateCondition", (Object)this.stateConditionAsString()).add("StatusCondition", (Object)this.statusConditionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrConditions": {
                return Optional.ofNullable(clazz.cast(this.orConditions()));
            }
            case "AndConditions": {
                return Optional.ofNullable(clazz.cast(this.andConditions()));
            }
            case "StringCondition": {
                return Optional.ofNullable(clazz.cast(this.stringCondition()));
            }
            case "StateCondition": {
                return Optional.ofNullable(clazz.cast(this.stateConditionAsString()));
            }
            case "StatusCondition": {
                return Optional.ofNullable(clazz.cast(this.statusConditionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OrConditions", OR_CONDITIONS_FIELD);
        map.put("AndConditions", AND_CONDITIONS_FIELD);
        map.put("StringCondition", STRING_CONDITION_FIELD);
        map.put("StateCondition", STATE_CONDITION_FIELD);
        map.put("StatusCondition", STATUS_CONDITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContactFlowModuleSearchCriteria, T> g) {
        return obj -> g.apply((ContactFlowModuleSearchCriteria)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ContactFlowModuleSearchCriteria> orConditions = DefaultSdkAutoConstructList.getInstance();
        private List<ContactFlowModuleSearchCriteria> andConditions = DefaultSdkAutoConstructList.getInstance();
        private StringCondition stringCondition;
        private String stateCondition;
        private String statusCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(ContactFlowModuleSearchCriteria model) {
            this.orConditions(model.orConditions);
            this.andConditions(model.andConditions);
            this.stringCondition(model.stringCondition);
            this.stateCondition(model.stateCondition);
            this.statusCondition(model.statusCondition);
        }

        public final List<Builder> getOrConditions() {
            List<Builder> result = ContactFlowModuleSearchConditionListCopier.copyToBuilder(this.orConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrConditions(Collection<BuilderImpl> orConditions) {
            this.orConditions = ContactFlowModuleSearchConditionListCopier.copyFromBuilder(orConditions);
        }

        @Override
        public final Builder orConditions(Collection<ContactFlowModuleSearchCriteria> orConditions) {
            this.orConditions = ContactFlowModuleSearchConditionListCopier.copy(orConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orConditions(ContactFlowModuleSearchCriteria ... orConditions) {
            this.orConditions(Arrays.asList(orConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orConditions(Consumer<Builder> ... orConditions) {
            this.orConditions(Stream.of(orConditions).map(c -> (ContactFlowModuleSearchCriteria)((Builder)ContactFlowModuleSearchCriteria.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Builder> getAndConditions() {
            List<Builder> result = ContactFlowModuleSearchConditionListCopier.copyToBuilder(this.andConditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAndConditions(Collection<BuilderImpl> andConditions) {
            this.andConditions = ContactFlowModuleSearchConditionListCopier.copyFromBuilder(andConditions);
        }

        @Override
        public final Builder andConditions(Collection<ContactFlowModuleSearchCriteria> andConditions) {
            this.andConditions = ContactFlowModuleSearchConditionListCopier.copy(andConditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andConditions(ContactFlowModuleSearchCriteria ... andConditions) {
            this.andConditions(Arrays.asList(andConditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andConditions(Consumer<Builder> ... andConditions) {
            this.andConditions(Stream.of(andConditions).map(c -> (ContactFlowModuleSearchCriteria)((Builder)ContactFlowModuleSearchCriteria.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final StringCondition.Builder getStringCondition() {
            return this.stringCondition != null ? this.stringCondition.toBuilder() : null;
        }

        public final void setStringCondition(StringCondition.BuilderImpl stringCondition) {
            this.stringCondition = stringCondition != null ? stringCondition.build() : null;
        }

        @Override
        public final Builder stringCondition(StringCondition stringCondition) {
            this.stringCondition = stringCondition;
            return this;
        }

        public final String getStateCondition() {
            return this.stateCondition;
        }

        public final void setStateCondition(String stateCondition) {
            this.stateCondition = stateCondition;
        }

        @Override
        public final Builder stateCondition(String stateCondition) {
            this.stateCondition = stateCondition;
            return this;
        }

        @Override
        public final Builder stateCondition(ContactFlowModuleState stateCondition) {
            this.stateCondition(stateCondition == null ? null : stateCondition.toString());
            return this;
        }

        public final String getStatusCondition() {
            return this.statusCondition;
        }

        public final void setStatusCondition(String statusCondition) {
            this.statusCondition = statusCondition;
        }

        @Override
        public final Builder statusCondition(String statusCondition) {
            this.statusCondition = statusCondition;
            return this;
        }

        @Override
        public final Builder statusCondition(ContactFlowModuleStatus statusCondition) {
            this.statusCondition(statusCondition == null ? null : statusCondition.toString());
            return this;
        }

        public ContactFlowModuleSearchCriteria build() {
            return new ContactFlowModuleSearchCriteria(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContactFlowModuleSearchCriteria> {
        public Builder orConditions(Collection<ContactFlowModuleSearchCriteria> var1);

        public Builder orConditions(ContactFlowModuleSearchCriteria ... var1);

        public Builder orConditions(Consumer<Builder> ... var1);

        public Builder andConditions(Collection<ContactFlowModuleSearchCriteria> var1);

        public Builder andConditions(ContactFlowModuleSearchCriteria ... var1);

        public Builder andConditions(Consumer<Builder> ... var1);

        public Builder stringCondition(StringCondition var1);

        default public Builder stringCondition(Consumer<StringCondition.Builder> stringCondition) {
            return this.stringCondition((StringCondition)((StringCondition.Builder)StringCondition.builder().applyMutation(stringCondition)).build());
        }

        public Builder stateCondition(String var1);

        public Builder stateCondition(ContactFlowModuleState var1);

        public Builder statusCondition(String var1);

        public Builder statusCondition(ContactFlowModuleStatus var1);
    }
}

