/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.ContactReferencesCopier;
import software.amazon.awssdk.services.connect.model.Endpoint;
import software.amazon.awssdk.services.connect.model.QueueInfoInput;
import software.amazon.awssdk.services.connect.model.Reference;
import software.amazon.awssdk.services.connect.model.SegmentAttributeValue;
import software.amazon.awssdk.services.connect.model.SegmentAttributesCopier;
import software.amazon.awssdk.services.connect.model.UserInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateContactRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, UpdateContactRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(UpdateContactRequest.getter(UpdateContactRequest::instanceId)).setter(UpdateContactRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactId").getter(UpdateContactRequest.getter(UpdateContactRequest::contactId)).setter(UpdateContactRequest.setter(Builder::contactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ContactId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateContactRequest.getter(UpdateContactRequest::name)).setter(UpdateContactRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateContactRequest.getter(UpdateContactRequest::description)).setter(UpdateContactRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Map<String, Reference>> REFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("References").getter(UpdateContactRequest.getter(UpdateContactRequest::references)).setter(UpdateContactRequest.setter(Builder::references)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("References").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Reference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, SegmentAttributeValue>> SEGMENT_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("SegmentAttributes").getter(UpdateContactRequest.getter(UpdateContactRequest::segmentAttributes)).setter(UpdateContactRequest.setter(Builder::segmentAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SegmentAttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<QueueInfoInput> QUEUE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("QueueInfo").getter(UpdateContactRequest.getter(UpdateContactRequest::queueInfo)).setter(UpdateContactRequest.setter(Builder::queueInfo)).constructor(QueueInfoInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueInfo").build()}).build();
    private static final SdkField<UserInfo> USER_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UserInfo").getter(UpdateContactRequest.getter(UpdateContactRequest::userInfo)).setter(UpdateContactRequest.setter(Builder::userInfo)).constructor(UserInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserInfo").build()}).build();
    private static final SdkField<Endpoint> CUSTOMER_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CustomerEndpoint").getter(UpdateContactRequest.getter(UpdateContactRequest::customerEndpoint)).setter(UpdateContactRequest.setter(Builder::customerEndpoint)).constructor(Endpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerEndpoint").build()}).build();
    private static final SdkField<Endpoint> SYSTEM_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SystemEndpoint").getter(UpdateContactRequest.getter(UpdateContactRequest::systemEndpoint)).setter(UpdateContactRequest.setter(Builder::systemEndpoint)).constructor(Endpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SystemEndpoint").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, CONTACT_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, REFERENCES_FIELD, SEGMENT_ATTRIBUTES_FIELD, QUEUE_INFO_FIELD, USER_INFO_FIELD, CUSTOMER_ENDPOINT_FIELD, SYSTEM_ENDPOINT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateContactRequest.memberNameToFieldInitializer();
    private final String instanceId;
    private final String contactId;
    private final String name;
    private final String description;
    private final Map<String, Reference> references;
    private final Map<String, SegmentAttributeValue> segmentAttributes;
    private final QueueInfoInput queueInfo;
    private final UserInfo userInfo;
    private final Endpoint customerEndpoint;
    private final Endpoint systemEndpoint;

    private UpdateContactRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.contactId = builder.contactId;
        this.name = builder.name;
        this.description = builder.description;
        this.references = builder.references;
        this.segmentAttributes = builder.segmentAttributes;
        this.queueInfo = builder.queueInfo;
        this.userInfo = builder.userInfo;
        this.customerEndpoint = builder.customerEndpoint;
        this.systemEndpoint = builder.systemEndpoint;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String contactId() {
        return this.contactId;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasReferences() {
        return this.references != null && !(this.references instanceof SdkAutoConstructMap);
    }

    public final Map<String, Reference> references() {
        return this.references;
    }

    public final boolean hasSegmentAttributes() {
        return this.segmentAttributes != null && !(this.segmentAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, SegmentAttributeValue> segmentAttributes() {
        return this.segmentAttributes;
    }

    public final QueueInfoInput queueInfo() {
        return this.queueInfo;
    }

    public final UserInfo userInfo() {
        return this.userInfo;
    }

    public final Endpoint customerEndpoint() {
        return this.customerEndpoint;
    }

    public final Endpoint systemEndpoint() {
        return this.systemEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReferences() ? this.references() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSegmentAttributes() ? this.segmentAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.queueInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.userInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.systemEndpoint());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateContactRequest)) {
            return false;
        }
        UpdateContactRequest other = (UpdateContactRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.contactId(), other.contactId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasReferences() == other.hasReferences() && Objects.equals(this.references(), other.references()) && this.hasSegmentAttributes() == other.hasSegmentAttributes() && Objects.equals(this.segmentAttributes(), other.segmentAttributes()) && Objects.equals(this.queueInfo(), other.queueInfo()) && Objects.equals(this.userInfo(), other.userInfo()) && Objects.equals(this.customerEndpoint(), other.customerEndpoint()) && Objects.equals(this.systemEndpoint(), other.systemEndpoint());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateContactRequest").add("InstanceId", (Object)this.instanceId()).add("ContactId", (Object)this.contactId()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("References", this.hasReferences() ? this.references() : null).add("SegmentAttributes", this.hasSegmentAttributes() ? this.segmentAttributes() : null).add("QueueInfo", (Object)this.queueInfo()).add("UserInfo", (Object)this.userInfo()).add("CustomerEndpoint", (Object)this.customerEndpoint()).add("SystemEndpoint", (Object)this.systemEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "ContactId": {
                return Optional.ofNullable(clazz.cast(this.contactId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "References": {
                return Optional.ofNullable(clazz.cast(this.references()));
            }
            case "SegmentAttributes": {
                return Optional.ofNullable(clazz.cast(this.segmentAttributes()));
            }
            case "QueueInfo": {
                return Optional.ofNullable(clazz.cast(this.queueInfo()));
            }
            case "UserInfo": {
                return Optional.ofNullable(clazz.cast(this.userInfo()));
            }
            case "CustomerEndpoint": {
                return Optional.ofNullable(clazz.cast(this.customerEndpoint()));
            }
            case "SystemEndpoint": {
                return Optional.ofNullable(clazz.cast(this.systemEndpoint()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("ContactId", CONTACT_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("References", REFERENCES_FIELD);
        map.put("SegmentAttributes", SEGMENT_ATTRIBUTES_FIELD);
        map.put("QueueInfo", QUEUE_INFO_FIELD);
        map.put("UserInfo", USER_INFO_FIELD);
        map.put("CustomerEndpoint", CUSTOMER_ENDPOINT_FIELD);
        map.put("SystemEndpoint", SYSTEM_ENDPOINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateContactRequest, T> g) {
        return obj -> g.apply((UpdateContactRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String contactId;
        private String name;
        private String description;
        private Map<String, Reference> references = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, SegmentAttributeValue> segmentAttributes = DefaultSdkAutoConstructMap.getInstance();
        private QueueInfoInput queueInfo;
        private UserInfo userInfo;
        private Endpoint customerEndpoint;
        private Endpoint systemEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateContactRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.contactId(model.contactId);
            this.name(model.name);
            this.description(model.description);
            this.references(model.references);
            this.segmentAttributes(model.segmentAttributes);
            this.queueInfo(model.queueInfo);
            this.userInfo(model.userInfo);
            this.customerEndpoint(model.customerEndpoint);
            this.systemEndpoint(model.systemEndpoint);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getContactId() {
            return this.contactId;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        @Override
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, Reference.Builder> getReferences() {
            Map<String, Reference.Builder> result = ContactReferencesCopier.copyToBuilder(this.references);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setReferences(Map<String, Reference.BuilderImpl> references) {
            this.references = ContactReferencesCopier.copyFromBuilder(references);
        }

        @Override
        public final Builder references(Map<String, Reference> references) {
            this.references = ContactReferencesCopier.copy(references);
            return this;
        }

        public final Map<String, SegmentAttributeValue.Builder> getSegmentAttributes() {
            Map<String, SegmentAttributeValue.Builder> result = SegmentAttributesCopier.copyToBuilder(this.segmentAttributes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setSegmentAttributes(Map<String, SegmentAttributeValue.BuilderImpl> segmentAttributes) {
            this.segmentAttributes = SegmentAttributesCopier.copyFromBuilder(segmentAttributes);
        }

        @Override
        public final Builder segmentAttributes(Map<String, SegmentAttributeValue> segmentAttributes) {
            this.segmentAttributes = SegmentAttributesCopier.copy(segmentAttributes);
            return this;
        }

        public final QueueInfoInput.Builder getQueueInfo() {
            return this.queueInfo != null ? this.queueInfo.toBuilder() : null;
        }

        public final void setQueueInfo(QueueInfoInput.BuilderImpl queueInfo) {
            this.queueInfo = queueInfo != null ? queueInfo.build() : null;
        }

        @Override
        public final Builder queueInfo(QueueInfoInput queueInfo) {
            this.queueInfo = queueInfo;
            return this;
        }

        public final UserInfo.Builder getUserInfo() {
            return this.userInfo != null ? this.userInfo.toBuilder() : null;
        }

        public final void setUserInfo(UserInfo.BuilderImpl userInfo) {
            this.userInfo = userInfo != null ? userInfo.build() : null;
        }

        @Override
        public final Builder userInfo(UserInfo userInfo) {
            this.userInfo = userInfo;
            return this;
        }

        public final Endpoint.Builder getCustomerEndpoint() {
            return this.customerEndpoint != null ? this.customerEndpoint.toBuilder() : null;
        }

        public final void setCustomerEndpoint(Endpoint.BuilderImpl customerEndpoint) {
            this.customerEndpoint = customerEndpoint != null ? customerEndpoint.build() : null;
        }

        @Override
        public final Builder customerEndpoint(Endpoint customerEndpoint) {
            this.customerEndpoint = customerEndpoint;
            return this;
        }

        public final Endpoint.Builder getSystemEndpoint() {
            return this.systemEndpoint != null ? this.systemEndpoint.toBuilder() : null;
        }

        public final void setSystemEndpoint(Endpoint.BuilderImpl systemEndpoint) {
            this.systemEndpoint = systemEndpoint != null ? systemEndpoint.build() : null;
        }

        @Override
        public final Builder systemEndpoint(Endpoint systemEndpoint) {
            this.systemEndpoint = systemEndpoint;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateContactRequest build() {
            return new UpdateContactRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateContactRequest> {
        public Builder instanceId(String var1);

        public Builder contactId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder references(Map<String, Reference> var1);

        public Builder segmentAttributes(Map<String, SegmentAttributeValue> var1);

        public Builder queueInfo(QueueInfoInput var1);

        default public Builder queueInfo(Consumer<QueueInfoInput.Builder> queueInfo) {
            return this.queueInfo((QueueInfoInput)((QueueInfoInput.Builder)QueueInfoInput.builder().applyMutation(queueInfo)).build());
        }

        public Builder userInfo(UserInfo var1);

        default public Builder userInfo(Consumer<UserInfo.Builder> userInfo) {
            return this.userInfo((UserInfo)((UserInfo.Builder)UserInfo.builder().applyMutation(userInfo)).build());
        }

        public Builder customerEndpoint(Endpoint var1);

        default public Builder customerEndpoint(Consumer<Endpoint.Builder> customerEndpoint) {
            return this.customerEndpoint((Endpoint)((Endpoint.Builder)Endpoint.builder().applyMutation(customerEndpoint)).build());
        }

        public Builder systemEndpoint(Endpoint var1);

        default public Builder systemEndpoint(Consumer<Endpoint.Builder> systemEndpoint) {
            return this.systemEndpoint((Endpoint)((Endpoint.Builder)Endpoint.builder().applyMutation(systemEndpoint)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

