/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.EvaluationAnswerInput;
import software.amazon.awssdk.services.connect.model.EvaluationAnswersInputMapCopier;
import software.amazon.awssdk.services.connect.model.EvaluationNote;
import software.amazon.awssdk.services.connect.model.EvaluationNotesMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateContactEvaluationRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, UpdateContactEvaluationRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(UpdateContactEvaluationRequest.getter(UpdateContactEvaluationRequest::instanceId)).setter(UpdateContactEvaluationRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<String> EVALUATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationId").getter(UpdateContactEvaluationRequest.getter(UpdateContactEvaluationRequest::evaluationId)).setter(UpdateContactEvaluationRequest.setter(Builder::evaluationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("EvaluationId").build()}).build();
    private static final SdkField<Map<String, EvaluationAnswerInput>> ANSWERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Answers").getter(UpdateContactEvaluationRequest.getter(UpdateContactEvaluationRequest::answers)).setter(UpdateContactEvaluationRequest.setter(Builder::answers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Answers").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EvaluationAnswerInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, EvaluationNote>> NOTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Notes").getter(UpdateContactEvaluationRequest.getter(UpdateContactEvaluationRequest::notes)).setter(UpdateContactEvaluationRequest.setter(Builder::notes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EvaluationNote::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, EVALUATION_ID_FIELD, ANSWERS_FIELD, NOTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateContactEvaluationRequest.memberNameToFieldInitializer();
    private final String instanceId;
    private final String evaluationId;
    private final Map<String, EvaluationAnswerInput> answers;
    private final Map<String, EvaluationNote> notes;

    private UpdateContactEvaluationRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.evaluationId = builder.evaluationId;
        this.answers = builder.answers;
        this.notes = builder.notes;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String evaluationId() {
        return this.evaluationId;
    }

    public final boolean hasAnswers() {
        return this.answers != null && !(this.answers instanceof SdkAutoConstructMap);
    }

    public final Map<String, EvaluationAnswerInput> answers() {
        return this.answers;
    }

    public final boolean hasNotes() {
        return this.notes != null && !(this.notes instanceof SdkAutoConstructMap);
    }

    public final Map<String, EvaluationNote> notes() {
        return this.notes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnswers() ? this.answers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotes() ? this.notes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateContactEvaluationRequest)) {
            return false;
        }
        UpdateContactEvaluationRequest other = (UpdateContactEvaluationRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.evaluationId(), other.evaluationId()) && this.hasAnswers() == other.hasAnswers() && Objects.equals(this.answers(), other.answers()) && this.hasNotes() == other.hasNotes() && Objects.equals(this.notes(), other.notes());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateContactEvaluationRequest").add("InstanceId", (Object)this.instanceId()).add("EvaluationId", (Object)this.evaluationId()).add("Answers", this.hasAnswers() ? this.answers() : null).add("Notes", this.hasNotes() ? this.notes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "EvaluationId": {
                return Optional.ofNullable(clazz.cast(this.evaluationId()));
            }
            case "Answers": {
                return Optional.ofNullable(clazz.cast(this.answers()));
            }
            case "Notes": {
                return Optional.ofNullable(clazz.cast(this.notes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("EvaluationId", EVALUATION_ID_FIELD);
        map.put("Answers", ANSWERS_FIELD);
        map.put("Notes", NOTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateContactEvaluationRequest, T> g) {
        return obj -> g.apply((UpdateContactEvaluationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private String evaluationId;
        private Map<String, EvaluationAnswerInput> answers = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, EvaluationNote> notes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateContactEvaluationRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.evaluationId(model.evaluationId);
            this.answers(model.answers);
            this.notes(model.notes);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getEvaluationId() {
            return this.evaluationId;
        }

        public final void setEvaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
        }

        @Override
        public final Builder evaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
            return this;
        }

        public final Map<String, EvaluationAnswerInput.Builder> getAnswers() {
            Map<String, EvaluationAnswerInput.Builder> result = EvaluationAnswersInputMapCopier.copyToBuilder(this.answers);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setAnswers(Map<String, EvaluationAnswerInput.BuilderImpl> answers) {
            this.answers = EvaluationAnswersInputMapCopier.copyFromBuilder(answers);
        }

        @Override
        public final Builder answers(Map<String, EvaluationAnswerInput> answers) {
            this.answers = EvaluationAnswersInputMapCopier.copy(answers);
            return this;
        }

        public final Map<String, EvaluationNote.Builder> getNotes() {
            Map<String, EvaluationNote.Builder> result = EvaluationNotesMapCopier.copyToBuilder(this.notes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setNotes(Map<String, EvaluationNote.BuilderImpl> notes) {
            this.notes = EvaluationNotesMapCopier.copyFromBuilder(notes);
        }

        @Override
        public final Builder notes(Map<String, EvaluationNote> notes) {
            this.notes = EvaluationNotesMapCopier.copy(notes);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateContactEvaluationRequest build() {
            return new UpdateContactEvaluationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateContactEvaluationRequest> {
        public Builder instanceId(String var1);

        public Builder evaluationId(String var1);

        public Builder answers(Map<String, EvaluationAnswerInput> var1);

        public Builder notes(Map<String, EvaluationNote> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

